/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.util.data;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.User;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.auth.AuthCredential;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class EmailLinkPersistenceManager {
    private static final String SHARED_PREF_NAME = "com.firebase.ui.auth.util.data.EmailLinkPersistenceManager";
    private static final String KEY_EMAIL = "com.firebase.ui.auth.data.client.email";
    private static final String KEY_PROVIDER = "com.firebase.ui.auth.data.client.provider";
    private static final String KEY_IDP_TOKEN = "com.firebase.ui.auth.data.client.idpToken";
    private static final String KEY_IDP_SECRET = "com.firebase.ui.auth.data.client.idpSecret";
    private static final String KEY_ANONYMOUS_USER_ID = "com.firebase.ui.auth.data.client.auid";
    private static final String KEY_SESSION_ID = "com.firebase.ui.auth.data.client.sid";
    private static final Set<String> KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("com.firebase.ui.auth.data.client.email", "com.firebase.ui.auth.data.client.provider", "com.firebase.ui.auth.data.client.idpToken", "com.firebase.ui.auth.data.client.idpSecret")));
    private static final EmailLinkPersistenceManager instance = new EmailLinkPersistenceManager();
    private AuthCredential mCredentialForLinking;

    public static EmailLinkPersistenceManager getInstance() {
        return instance;
    }

    public void saveEmail(@NonNull Context context, @NonNull String email, @NonNull String sessionId, @Nullable String anonymousUserId) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)email);
        SharedPreferences.Editor editor = context.getSharedPreferences(SHARED_PREF_NAME, 0).edit();
        editor.putString(KEY_EMAIL, email);
        editor.putString(KEY_ANONYMOUS_USER_ID, anonymousUserId);
        editor.putString(KEY_SESSION_ID, sessionId);
        editor.apply();
    }

    public void saveIdpResponseForLinking(@NonNull Context context, @NonNull IdpResponse idpResponseForLinking) {
        if (idpResponseForLinking.hasCredentialForLinking()) {
            this.mCredentialForLinking = idpResponseForLinking.getCredentialForLinking();
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)idpResponseForLinking);
        SharedPreferences.Editor editor = context.getSharedPreferences(SHARED_PREF_NAME, 0).edit();
        editor.putString(KEY_EMAIL, idpResponseForLinking.getEmail());
        editor.putString(KEY_PROVIDER, idpResponseForLinking.getProviderType());
        editor.putString(KEY_IDP_TOKEN, idpResponseForLinking.getIdpToken());
        editor.putString(KEY_IDP_SECRET, idpResponseForLinking.getIdpSecret());
        editor.apply();
    }

    @Nullable
    public SessionRecord retrieveSessionRecord(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREF_NAME, 0);
        String email = sharedPreferences.getString(KEY_EMAIL, null);
        String sessionId = sharedPreferences.getString(KEY_SESSION_ID, null);
        if (email == null || sessionId == null) {
            return null;
        }
        String anonymousUserId = sharedPreferences.getString(KEY_ANONYMOUS_USER_ID, null);
        String provider = sharedPreferences.getString(KEY_PROVIDER, null);
        String idpToken = sharedPreferences.getString(KEY_IDP_TOKEN, null);
        String idpSecret = sharedPreferences.getString(KEY_IDP_SECRET, null);
        SessionRecord sessionRecord = new SessionRecord(sessionId, anonymousUserId).setEmail(email);
        if (provider != null && (idpToken != null || this.mCredentialForLinking != null)) {
            IdpResponse response = new IdpResponse.Builder(new User.Builder(provider, email).build()).setPendingCredential(this.mCredentialForLinking).setToken(idpToken).setSecret(idpSecret).setNewUser(false).build();
            sessionRecord.setIdpResponseForLinking(response);
        }
        this.mCredentialForLinking = null;
        return sessionRecord;
    }

    public void clearAllData(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPreferences = context.getSharedPreferences(SHARED_PREF_NAME, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        for (String key : KEYS) {
            editor.remove(key);
        }
        editor.apply();
    }

    public static class SessionRecord {
        private String mSessionId;
        private String mEmail;
        @Nullable
        private String mAnonymousUserId;
        @Nullable
        private IdpResponse mIdpResponseForLinking;

        public SessionRecord(@NonNull String sessionId, @Nullable String anonymousUserId) {
            Preconditions.checkNotNull((Object)sessionId);
            this.mSessionId = sessionId;
            this.mAnonymousUserId = anonymousUserId;
        }

        public String getSessionId() {
            return this.mSessionId;
        }

        public String getEmail() {
            return this.mEmail;
        }

        public SessionRecord setEmail(@NonNull String email) {
            this.mEmail = email;
            return this;
        }

        @Nullable
        public IdpResponse getIdpResponseForLinking() {
            return this.mIdpResponseForLinking;
        }

        public SessionRecord setIdpResponseForLinking(@NonNull IdpResponse idpResponseForLinking) {
            this.mIdpResponseForLinking = idpResponseForLinking;
            return this;
        }

        @Nullable
        public String getAnonymousUserId() {
            return this.mAnonymousUserId;
        }
    }
}

