/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.phone;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.State;
import com.firebase.ui.auth.ui.FragmentBase;
import com.firebase.ui.auth.ui.phone.PhoneNumberVerificationHandler;
import com.firebase.ui.auth.ui.phone.SpacedEditText;
import com.firebase.ui.auth.util.data.PrivacyDisclosureUtils;
import com.firebase.ui.auth.util.ui.BucketedTextChangeListener;
import com.firebase.ui.auth.viewmodel.phone.PhoneProviderResponseHandler;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SubmitConfirmationCodeFragment
extends FragmentBase {
    public static final String TAG = "SubmitConfirmationCodeFragment";
    private static final int VERIFICATION_CODE_LENGTH = 6;
    private static final long RESEND_WAIT_MILLIS = 60000L;
    private static final long TICK_INTERVAL_MILLIS = 500L;
    private static final String EXTRA_MILLIS_UNTIL_FINISHED = "millis_until_finished";
    private final Handler mLooper = new Handler();
    private final Runnable mCountdown = () -> this.processCountdownTick();
    private PhoneNumberVerificationHandler mHandler;
    private String mPhoneNumber;
    private ProgressBar mProgressBar;
    private TextView mPhoneTextView;
    private TextView mResendCodeTextView;
    private TextView mCountDownTextView;
    private SpacedEditText mConfirmationCodeEditText;
    private long mMillisUntilFinished = 60000L;
    private boolean mHasResumed;

    public static SubmitConfirmationCodeFragment newInstance(String phoneNumber) {
        SubmitConfirmationCodeFragment fragment = new SubmitConfirmationCodeFragment();
        Bundle args = new Bundle();
        args.putString("extra_phone_number", phoneNumber);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mHandler = (PhoneNumberVerificationHandler)new ViewModelProvider((ViewModelStoreOwner)this.requireActivity()).get(PhoneNumberVerificationHandler.class);
        this.mPhoneNumber = this.getArguments().getString("extra_phone_number");
        if (savedInstanceState != null) {
            this.mMillisUntilFinished = savedInstanceState.getLong(EXTRA_MILLIS_UNTIL_FINISHED);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fui_confirmation_code_layout, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        this.mProgressBar = (ProgressBar)view.findViewById(R.id.top_progress_bar);
        this.mPhoneTextView = (TextView)view.findViewById(R.id.edit_phone_number);
        this.mCountDownTextView = (TextView)view.findViewById(R.id.ticker);
        this.mResendCodeTextView = (TextView)view.findViewById(R.id.resend_code);
        this.mConfirmationCodeEditText = (SpacedEditText)view.findViewById(R.id.confirmation_code);
        this.requireActivity().setTitle((CharSequence)this.getString(R.string.fui_verify_your_phone_title));
        this.processCountdownTick();
        this.setupConfirmationCodeEditText();
        this.setupEditPhoneNumberTextView();
        this.setupResendConfirmationCodeTextView();
        PrivacyDisclosureUtils.setupTermsOfServiceFooter(this.requireContext(), this.getFlowParams(), (TextView)view.findViewById(R.id.email_footer_tos_and_pp_text));
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        ((PhoneProviderResponseHandler)new ViewModelProvider((ViewModelStoreOwner)this.requireActivity()).get(PhoneProviderResponseHandler.class)).getOperation().observe(this.getViewLifecycleOwner(), resource -> {
            if (resource.getState() == State.FAILURE) {
                this.mConfirmationCodeEditText.setText("");
            }
        });
    }

    public void onStart() {
        super.onStart();
        this.mConfirmationCodeEditText.requestFocus();
        ((InputMethodManager)this.requireActivity().getSystemService("input_method")).showSoftInput((View)this.mConfirmationCodeEditText, 0);
    }

    public void onResume() {
        CharSequence candidate;
        super.onResume();
        if (!this.mHasResumed) {
            this.mHasResumed = true;
            return;
        }
        ClipData clip = ((ClipboardManager)ContextCompat.getSystemService((Context)this.requireContext(), ClipboardManager.class)).getPrimaryClip();
        if (clip != null && clip.getItemCount() == 1 && (candidate = clip.getItemAt(0).getText()) != null && candidate.length() == 6) {
            try {
                Integer.parseInt(candidate.toString());
                this.mConfirmationCodeEditText.setText(candidate);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.mLooper.removeCallbacks(this.mCountdown);
        this.mLooper.postDelayed(this.mCountdown, 500L);
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        this.mLooper.removeCallbacks(this.mCountdown);
        outState.putLong(EXTRA_MILLIS_UNTIL_FINISHED, this.mMillisUntilFinished);
    }

    public void onDestroy() {
        super.onDestroy();
        this.mLooper.removeCallbacks(this.mCountdown);
    }

    private void setupConfirmationCodeEditText() {
        this.mConfirmationCodeEditText.setText("------");
        this.mConfirmationCodeEditText.addTextChangedListener(new BucketedTextChangeListener((EditText)this.mConfirmationCodeEditText, 6, "-", new BucketedTextChangeListener.ContentChangeCallback(){

            @Override
            public void whenComplete() {
                SubmitConfirmationCodeFragment.this.submitCode();
            }

            @Override
            public void whileIncomplete() {
            }
        }));
    }

    private void setupEditPhoneNumberTextView() {
        this.mPhoneTextView.setText((CharSequence)this.mPhoneNumber);
        this.mPhoneTextView.setOnClickListener(v -> this.requireActivity().getSupportFragmentManager().popBackStack());
    }

    private void setupResendConfirmationCodeTextView() {
        this.mResendCodeTextView.setOnClickListener(v -> {
            this.mHandler.verifyPhoneNumber((Activity)this.requireActivity(), this.mPhoneNumber, true);
            this.mResendCodeTextView.setVisibility(8);
            this.mCountDownTextView.setVisibility(0);
            this.mCountDownTextView.setText((CharSequence)String.format(this.getString(R.string.fui_resend_code_in), 60L));
            this.mMillisUntilFinished = 60000L;
            this.mLooper.postDelayed(this.mCountdown, 500L);
        });
    }

    private void processCountdownTick() {
        this.mMillisUntilFinished -= 500L;
        if (this.mMillisUntilFinished <= 0L) {
            this.mCountDownTextView.setText((CharSequence)"");
            this.mCountDownTextView.setVisibility(8);
            this.mResendCodeTextView.setVisibility(0);
        } else {
            this.mCountDownTextView.setText((CharSequence)String.format(this.getString(R.string.fui_resend_code_in), TimeUnit.MILLISECONDS.toSeconds(this.mMillisUntilFinished) + 1L));
            this.mLooper.postDelayed(this.mCountdown, 500L);
        }
    }

    private void submitCode() {
        this.mHandler.submitVerificationCode(this.mPhoneNumber, this.mConfirmationCodeEditText.getUnspacedText().toString());
    }

    @Override
    public void showProgress(int message) {
        this.mProgressBar.setVisibility(0);
    }

    @Override
    public void hideProgress() {
        this.mProgressBar.setVisibility(4);
    }
}

