/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.idp;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.firebase.ui.auth.AuthUI;
import com.firebase.ui.auth.FirebaseAuthAnonymousUpgradeException;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.User;
import com.firebase.ui.auth.data.remote.FacebookSignInHandler;
import com.firebase.ui.auth.data.remote.GenericIdpSignInHandler;
import com.firebase.ui.auth.data.remote.GoogleSignInHandler;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.firebase.ui.auth.ui.InvisibleActivityBase;
import com.firebase.ui.auth.util.data.ProviderUtils;
import com.firebase.ui.auth.viewmodel.ProviderSignInBase;
import com.firebase.ui.auth.viewmodel.ResourceObserver;
import com.firebase.ui.auth.viewmodel.idp.SocialProviderResponseHandler;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SingleSignInActivity
extends InvisibleActivityBase {
    private SocialProviderResponseHandler mHandler;
    private ProviderSignInBase<?> mProvider;

    public static Intent createIntent(Context context, FlowParameters flowParams, User user) {
        return SingleSignInActivity.createBaseIntent(context, SingleSignInActivity.class, flowParams).putExtra("extra_user", (Parcelable)user);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        User user = User.getUser(this.getIntent());
        final String provider = user.getProviderId();
        AuthUI.IdpConfig providerConfig = ProviderUtils.getConfigFromIdps(this.getFlowParams().providers, provider);
        if (providerConfig == null) {
            this.finish(0, IdpResponse.getErrorIntent(new FirebaseUiException(3, "Provider not enabled: " + provider)));
            return;
        }
        ViewModelProvider supplier = new ViewModelProvider((ViewModelStoreOwner)this);
        this.mHandler = (SocialProviderResponseHandler)supplier.get(SocialProviderResponseHandler.class);
        this.mHandler.init(this.getFlowParams());
        boolean useEmulator = this.getAuthUI().isUseEmulator();
        switch (provider) {
            case "google.com": {
                if (useEmulator) {
                    this.mProvider = ((GenericIdpSignInHandler)supplier.get(GenericIdpSignInHandler.class)).initWith(GenericIdpSignInHandler.getGenericGoogleConfig());
                    break;
                }
                this.mProvider = ((GoogleSignInHandler)supplier.get(GoogleSignInHandler.class)).initWith(new GoogleSignInHandler.Params(providerConfig, user.getEmail()));
                break;
            }
            case "facebook.com": {
                if (useEmulator) {
                    this.mProvider = ((GenericIdpSignInHandler)supplier.get(GenericIdpSignInHandler.class)).initWith(GenericIdpSignInHandler.getGenericFacebookConfig());
                    break;
                }
                this.mProvider = ((FacebookSignInHandler)supplier.get(FacebookSignInHandler.class)).initWith(providerConfig);
                break;
            }
            default: {
                if (!TextUtils.isEmpty((CharSequence)providerConfig.getParams().getString("generic_oauth_provider_id"))) {
                    this.mProvider = ((GenericIdpSignInHandler)supplier.get(GenericIdpSignInHandler.class)).initWith(providerConfig);
                    break;
                }
                throw new IllegalStateException("Invalid provider id: " + provider);
            }
        }
        this.mProvider.getOperation().observe((LifecycleOwner)this, (Observer)new ResourceObserver<IdpResponse>((HelperActivityBase)this){

            @Override
            protected void onSuccess(@NonNull IdpResponse response) {
                boolean useSocialHandler;
                boolean bl = useSocialHandler = AuthUI.SOCIAL_PROVIDERS.contains(provider) && !SingleSignInActivity.this.getAuthUI().isUseEmulator();
                if (useSocialHandler || !response.isSuccessful()) {
                    SingleSignInActivity.this.mHandler.startSignIn(response);
                    return;
                }
                SingleSignInActivity.this.finish(response.isSuccessful() ? -1 : 0, response.toIntent());
            }

            @Override
            protected void onFailure(@NonNull Exception e) {
                if (e instanceof FirebaseAuthAnonymousUpgradeException) {
                    SingleSignInActivity.this.finish(0, new Intent().putExtra("extra_idp_response", (Parcelable)IdpResponse.from(e)));
                    return;
                }
                SingleSignInActivity.this.mHandler.startSignIn(IdpResponse.from(e));
            }
        });
        this.mHandler.getOperation().observe((LifecycleOwner)this, (Observer)new ResourceObserver<IdpResponse>((HelperActivityBase)this){

            @Override
            protected void onSuccess(@NonNull IdpResponse response) {
                SingleSignInActivity.this.startSaveCredentials(SingleSignInActivity.this.mHandler.getCurrentUser(), response, null);
            }

            @Override
            protected void onFailure(@NonNull Exception e) {
                if (e instanceof FirebaseAuthAnonymousUpgradeException) {
                    IdpResponse res = ((FirebaseAuthAnonymousUpgradeException)e).getResponse();
                    SingleSignInActivity.this.finish(0, new Intent().putExtra("extra_idp_response", (Parcelable)res));
                } else {
                    SingleSignInActivity.this.finish(0, IdpResponse.getErrorIntent(e));
                }
            }
        });
        if (this.mHandler.getOperation().getValue() == null) {
            this.mProvider.startSignIn(this.getAuth(), this, provider);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.mHandler.onActivityResult(requestCode, resultCode, data);
        this.mProvider.onActivityResult(requestCode, resultCode, data);
    }
}

