/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.email;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Bundle;
import android.text.SpannableStringBuilder;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.FragmentActivity;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.ui.FragmentBase;
import com.firebase.ui.auth.util.data.EmailLinkParser;
import com.firebase.ui.auth.util.data.PrivacyDisclosureUtils;
import com.firebase.ui.auth.util.data.ProviderUtils;
import com.firebase.ui.auth.util.ui.TextHelper;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class EmailLinkCrossDeviceLinkingFragment
extends FragmentBase
implements View.OnClickListener {
    public static final String TAG = "CrossDeviceFragment";
    private FinishEmailLinkSignInListener mListener;
    private ProgressBar mProgressBar;
    private Button mContinueButton;

    public static EmailLinkCrossDeviceLinkingFragment newInstance() {
        EmailLinkCrossDeviceLinkingFragment fragment = new EmailLinkCrossDeviceLinkingFragment();
        return fragment;
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fui_email_link_cross_device_linking, container, false);
    }

    @SuppressLint(value={"WrongConstant"})
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        this.mProgressBar = (ProgressBar)view.findViewById(R.id.top_progress_bar);
        this.mContinueButton = (Button)view.findViewById(R.id.button_continue);
        this.mContinueButton.setOnClickListener((View.OnClickListener)this);
        String link = this.getFlowParams().emailLink;
        EmailLinkParser parser = new EmailLinkParser(link);
        String providerId = parser.getProviderId();
        String providerName = ProviderUtils.providerIdToProviderName(providerId);
        TextView body = (TextView)view.findViewById(R.id.cross_device_linking_body);
        String bodyText = this.getString(R.string.fui_email_link_cross_device_linking_text, new Object[]{providerName});
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)bodyText);
        TextHelper.boldAllOccurencesOfText(spannableStringBuilder, bodyText, providerName);
        body.setText((CharSequence)spannableStringBuilder);
        if (Build.VERSION.SDK_INT >= 26) {
            body.setJustificationMode(1);
        }
        TextView footerText = (TextView)view.findViewById(R.id.email_footer_tos_and_pp_text);
        PrivacyDisclosureUtils.setupTermsOfServiceFooter(this.requireContext(), this.getFlowParams(), footerText);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        FragmentActivity activity = this.getActivity();
        if (!(activity instanceof FinishEmailLinkSignInListener)) {
            throw new IllegalStateException("Activity must implement EmailLinkPromptEmailListener");
        }
        this.mListener = (FinishEmailLinkSignInListener)activity;
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.button_continue) {
            this.mListener.completeCrossDeviceEmailLinkFlow();
        }
    }

    @Override
    public void showProgress(int message) {
        this.mProgressBar.setVisibility(0);
    }

    @Override
    public void hideProgress() {
        this.mProgressBar.setVisibility(4);
    }

    static interface FinishEmailLinkSignInListener {
        public void completeCrossDeviceEmailLinkFlow();
    }
}

