/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.data.remote;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.facebook.AccessToken;
import com.facebook.CallbackManager;
import com.facebook.FacebookCallback;
import com.facebook.FacebookException;
import com.facebook.FacebookRequestError;
import com.facebook.GraphRequest;
import com.facebook.GraphResponse;
import com.facebook.WebDialog;
import com.facebook.login.LoginManager;
import com.facebook.login.LoginResult;
import com.firebase.ui.auth.AuthUI;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.data.model.User;
import com.firebase.ui.auth.data.model.UserCancellationException;
import com.firebase.ui.auth.data.remote.SingleProviderSignInHandler;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.google.firebase.auth.FirebaseAuth;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class FacebookSignInHandler
extends SingleProviderSignInHandler<AuthUI.IdpConfig> {
    private static final String EMAIL = "email";
    private static final String PUBLIC_PROFILE = "public_profile";
    private List<String> mPermissions;
    private final FacebookCallback<LoginResult> mCallback = new Callback();
    private final CallbackManager mCallbackManager = CallbackManager.Factory.create();

    public FacebookSignInHandler(Application application) {
        super(application, "facebook.com");
    }

    private static IdpResponse createIdpResponse(LoginResult result, @Nullable String email, String name, Uri photoUri) {
        return new IdpResponse.Builder(new User.Builder("facebook.com", email).setName(name).setPhotoUri(photoUri).build()).setToken(result.getAccessToken().getToken()).build();
    }

    @Override
    protected void onCreate() {
        ArrayList<String> permissions = ((AuthUI.IdpConfig)this.getArguments()).getParams().getStringArrayList("extra_facebook_permissions");
        permissions = new ArrayList<String>(permissions == null ? Collections.emptyList() : permissions);
        if (!permissions.contains(EMAIL)) {
            permissions.add(EMAIL);
        }
        if (!permissions.contains(PUBLIC_PROFILE)) {
            permissions.add(PUBLIC_PROFILE);
        }
        this.mPermissions = permissions;
        LoginManager.getInstance().registerCallback(this.mCallbackManager, this.mCallback);
    }

    @Override
    public void startSignIn(@NonNull FirebaseAuth auth, @NonNull HelperActivityBase activity, @NonNull String providerId) {
        WebDialog.setWebDialogTheme((int)activity.getFlowParams().themeId);
        LoginManager.getInstance().logInWithReadPermissions((Activity)activity, this.mPermissions);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        this.mCallbackManager.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    protected void onCleared() {
        super.onCleared();
        LoginManager.getInstance().unregisterCallback(this.mCallbackManager);
    }

    private class ProfileRequest
    implements GraphRequest.GraphJSONObjectCallback {
        private final LoginResult mResult;

        public ProfileRequest(LoginResult result) {
            this.mResult = result;
        }

        public void onCompleted(JSONObject object, GraphResponse response) {
            FacebookRequestError error = response.getError();
            if (error != null) {
                FacebookSignInHandler.this.setResult(Resource.forFailure(new FirebaseUiException(4, (Throwable)error.getException())));
                return;
            }
            if (object == null) {
                FacebookSignInHandler.this.setResult(Resource.forFailure(new FirebaseUiException(4, "Facebook graph request failed")));
                return;
            }
            String email = null;
            String name = null;
            Uri photoUri = null;
            try {
                email = object.getString(FacebookSignInHandler.EMAIL);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            try {
                name = object.getString("name");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            try {
                photoUri = Uri.parse((String)object.getJSONObject("picture").getJSONObject("data").getString("url"));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            FacebookSignInHandler.this.setResult(Resource.forSuccess(FacebookSignInHandler.createIdpResponse(this.mResult, email, name, photoUri)));
        }
    }

    private class Callback
    implements FacebookCallback<LoginResult> {
        private Callback() {
        }

        public void onSuccess(LoginResult result) {
            FacebookSignInHandler.this.setResult(Resource.forLoading());
            GraphRequest request = GraphRequest.newMeRequest((AccessToken)result.getAccessToken(), (GraphRequest.GraphJSONObjectCallback)new ProfileRequest(result));
            Bundle parameters = new Bundle();
            parameters.putString("fields", "id,name,email,picture");
            request.setParameters(parameters);
            request.executeAsync();
        }

        public void onCancel() {
            FacebookSignInHandler.this.setResult(Resource.forFailure(new UserCancellationException()));
        }

        public void onError(FacebookException e) {
            FacebookSignInHandler.this.setResult(Resource.forFailure(new FirebaseUiException(4, (Throwable)e)));
        }
    }
}

