/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.AuthUI;
import com.firebase.ui.auth.FirebaseAuthAnonymousUpgradeException;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.FirebaseUiUserCollisionException;
import com.firebase.ui.auth.data.model.User;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class IdpResponse
implements Parcelable {
    public static final Parcelable.Creator<IdpResponse> CREATOR = new Parcelable.Creator<IdpResponse>(){

        public IdpResponse createFromParcel(Parcel in) {
            return new IdpResponse((User)in.readParcelable(User.class.getClassLoader()), in.readString(), in.readString(), in.readInt() == 1, (FirebaseUiException)in.readSerializable(), (AuthCredential)in.readParcelable(AuthCredential.class.getClassLoader()));
        }

        public IdpResponse[] newArray(int size) {
            return new IdpResponse[size];
        }
    };
    private final User mUser;
    private final AuthCredential mPendingCredential;
    private final String mToken;
    private final String mSecret;
    private final boolean mIsNewUser;
    private final FirebaseUiException mException;

    private IdpResponse(@NonNull FirebaseUiException e) {
        this(null, null, null, false, e, null);
    }

    private IdpResponse(@NonNull User user, @Nullable String token, @Nullable String secret, @Nullable AuthCredential pendingCredential, boolean isNewUser) {
        this(user, token, secret, isNewUser, null, pendingCredential);
    }

    private IdpResponse(AuthCredential credential, FirebaseUiException e) {
        this(null, null, null, false, e, credential);
    }

    private IdpResponse(User user, String token, String secret, boolean isNewUser, FirebaseUiException e, AuthCredential credential) {
        this.mUser = user;
        this.mToken = token;
        this.mSecret = secret;
        this.mIsNewUser = isNewUser;
        this.mException = e;
        this.mPendingCredential = credential;
    }

    @Nullable
    public static IdpResponse fromResultIntent(@Nullable Intent resultIntent) {
        if (resultIntent != null) {
            return (IdpResponse)resultIntent.getParcelableExtra("extra_idp_response");
        }
        return null;
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static IdpResponse from(@NonNull Exception e) {
        if (e instanceof FirebaseUiException) {
            return new IdpResponse((FirebaseUiException)e);
        }
        if (e instanceof FirebaseAuthAnonymousUpgradeException) {
            return ((FirebaseAuthAnonymousUpgradeException)e).getResponse();
        }
        if (e instanceof FirebaseUiUserCollisionException) {
            FirebaseUiUserCollisionException collisionException = (FirebaseUiUserCollisionException)e;
            User user = new User.Builder(collisionException.getProviderId(), collisionException.getEmail()).build();
            return new IdpResponse(user, null, null, false, new FirebaseUiException(collisionException.getErrorCode(), collisionException.getMessage()), collisionException.getCredential());
        }
        FirebaseUiException wrapped = new FirebaseUiException(0, e.getMessage());
        wrapped.setStackTrace(e.getStackTrace());
        return new IdpResponse(wrapped);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static Intent getErrorIntent(@NonNull Exception e) {
        return IdpResponse.from(e).toIntent();
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public IdpResponse withResult(AuthResult result) {
        return this.mutate().setNewUser(result.getAdditionalUserInfo().isNewUser()).build();
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Intent toIntent() {
        return new Intent().putExtra("extra_idp_response", (Parcelable)this);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Builder mutate() {
        if (!this.isSuccessful()) {
            throw new IllegalStateException("Cannot mutate an unsuccessful response.");
        }
        return new Builder(this);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isSuccessful() {
        return this.mException == null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public User getUser() {
        return this.mUser;
    }

    @Nullable
    public String getProviderType() {
        return this.mUser != null ? this.mUser.getProviderId() : null;
    }

    public boolean isNewUser() {
        return this.mIsNewUser;
    }

    @Nullable
    public String getEmail() {
        return this.mUser != null ? this.mUser.getEmail() : null;
    }

    @Nullable
    public String getPhoneNumber() {
        return this.mUser != null ? this.mUser.getPhoneNumber() : null;
    }

    @Nullable
    public String getIdpToken() {
        return this.mToken;
    }

    @Nullable
    public String getIdpSecret() {
        return this.mSecret;
    }

    @Nullable
    public FirebaseUiException getError() {
        return this.mException;
    }

    @Nullable
    public AuthCredential getCredentialForLinking() {
        return this.mPendingCredential;
    }

    @Nullable
    public boolean hasCredentialForLinking() {
        return this.mPendingCredential != null;
    }

    public boolean isRecoverableErrorResponse() {
        return this.mPendingCredential != null || this.getEmail() != null;
    }

    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.mUser, flags);
        dest.writeString(this.mToken);
        dest.writeString(this.mSecret);
        dest.writeInt(this.mIsNewUser ? 1 : 0);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new ByteArrayOutputStream());
            oos.writeObject(this.mException);
            dest.writeSerializable((Serializable)this.mException);
        }
        catch (IOException e) {
            FirebaseUiException fake = new FirebaseUiException(0, "Exception serialization error, forced wrapping. Original: " + this.mException + ", original cause: " + this.mException.getCause());
            fake.setStackTrace(this.mException.getStackTrace());
            dest.writeSerializable((Serializable)fake);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
        dest.writeParcelable((Parcelable)this.mPendingCredential, 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdpResponse response = (IdpResponse)o;
        return (this.mUser == null ? response.mUser == null : this.mUser.equals(response.mUser)) && (this.mToken == null ? response.mToken == null : this.mToken.equals(response.mToken)) && (this.mSecret == null ? response.mSecret == null : this.mSecret.equals(response.mSecret)) && this.mIsNewUser == response.mIsNewUser && (this.mException == null ? response.mException == null : this.mException.equals(response.mException)) && (this.mPendingCredential == null ? response.mPendingCredential == null : this.mPendingCredential.getProvider().equals(response.mPendingCredential.getProvider()));
    }

    public int hashCode() {
        int result = this.mUser == null ? 0 : this.mUser.hashCode();
        result = 31 * result + (this.mToken == null ? 0 : this.mToken.hashCode());
        result = 31 * result + (this.mSecret == null ? 0 : this.mSecret.hashCode());
        result = 31 * result + (this.mIsNewUser ? 1 : 0);
        result = 31 * result + (this.mException == null ? 0 : this.mException.hashCode());
        result = 31 * result + (this.mPendingCredential == null ? 0 : this.mPendingCredential.getProvider().hashCode());
        return result;
    }

    public String toString() {
        return "IdpResponse{mUser=" + this.mUser + ", mToken='" + this.mToken + '\'' + ", mSecret='" + this.mSecret + '\'' + ", mIsNewUser='" + this.mIsNewUser + '\'' + ", mException=" + this.mException + ", mPendingCredential=" + this.mPendingCredential + '}';
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class Builder {
        private User mUser;
        private AuthCredential mPendingCredential;
        private String mToken;
        private String mSecret;
        private boolean mIsNewUser;

        public Builder() {
        }

        public Builder(@NonNull User user) {
            this.mUser = user;
        }

        public Builder(@NonNull IdpResponse response) {
            this.mUser = response.mUser;
            this.mToken = response.mToken;
            this.mSecret = response.mSecret;
            this.mIsNewUser = response.mIsNewUser;
            this.mPendingCredential = response.mPendingCredential;
        }

        public Builder setNewUser(boolean newUser) {
            this.mIsNewUser = newUser;
            return this;
        }

        public Builder setToken(String token) {
            this.mToken = token;
            return this;
        }

        public Builder setSecret(String secret) {
            this.mSecret = secret;
            return this;
        }

        public Builder setPendingCredential(AuthCredential credential) {
            this.mPendingCredential = credential;
            return this;
        }

        public IdpResponse build() {
            if (this.mPendingCredential != null && this.mUser == null) {
                return new IdpResponse(this.mPendingCredential, new FirebaseUiException(5));
            }
            String providerId = this.mUser.getProviderId();
            if (AuthUI.SOCIAL_PROVIDERS.contains(providerId) && TextUtils.isEmpty((CharSequence)this.mToken)) {
                throw new IllegalStateException("Token cannot be null when using a non-email provider.");
            }
            if (providerId.equals("twitter.com") && TextUtils.isEmpty((CharSequence)this.mSecret)) {
                throw new IllegalStateException("Secret cannot be null when using the Twitter provider.");
            }
            return new IdpResponse(this.mUser, this.mToken, this.mSecret, this.mPendingCredential, this.mIsNewUser);
        }
    }
}

