/*
 * Decompiled with CFR 0.152.
 */
package com.fintonic.versioning.domain;

import com.fintonic.versioning.domain.Version;
import org.springframework.util.StringUtils;

public class VersionRange {
    private final Version from;
    private final Version to;

    public VersionRange(String from, String to) {
        if (StringUtils.isEmpty((Object)from)) {
            throw new IllegalArgumentException("Define from in @VersionedResource");
        }
        this.from = new Version(from);
        this.to = new Version(to);
        if (this.from.compareTo(this.to) != -1 && this.from.compareTo(this.to) != 0) {
            throw new IllegalArgumentException("From is minor than to, bad definition");
        }
    }

    public boolean includes(String other) {
        Version otherVersion = new Version(other);
        return this.from.compareTo(otherVersion) <= 0 && this.to.compareTo(otherVersion) >= 0;
    }

    public String toString() {
        return "range[" + this.from + "-" + this.to + "]";
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VersionRange)) {
            return false;
        }
        VersionRange that = (VersionRange)o;
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        return this.to != null ? this.to.equals(that.to) : that.to == null;
    }

    public final int hashCode() {
        int result = this.from != null ? this.from.hashCode() : 0;
        result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
        return result;
    }
}

