/*
 * Decompiled with CFR 0.152.
 */
package com.fintonic.versioning.configuration;

import com.fintonic.versioning.annotation.VersionedResource;
import com.fintonic.versioning.configuration.VersionRequestCondition;
import com.fintonic.versioning.domain.PathVersionMap;
import java.lang.reflect.Method;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class VersionRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    protected RequestCondition<?> getCustomTypeCondition(Class<?> handlerType) {
        VersionedResource versionResourceAnnotation = (VersionedResource)AnnotationUtils.findAnnotation(handlerType, VersionedResource.class);
        if (versionResourceAnnotation != null) {
            if (StringUtils.isEmpty((Object)versionResourceAnnotation.media())) {
                throw new IllegalArgumentException("Media cannot be null in class annotation");
            }
            return this.createCondition(versionResourceAnnotation.media(), versionResourceAnnotation.from(), versionResourceAnnotation.to(), "");
        }
        return null;
    }

    protected RequestCondition<?> getCustomMethodCondition(Method method) {
        VersionedResource methodAnnotation = (VersionedResource)AnnotationUtils.findAnnotation((Method)method, VersionedResource.class);
        if (methodAnnotation != null && StringUtils.isEmpty((Object)methodAnnotation.from())) {
            throw new IllegalArgumentException("From must be declared in method");
        }
        RequestMapping requestMappingClass = (RequestMapping)AnnotationUtils.findAnnotation(method.getDeclaringClass(), RequestMapping.class);
        String classPath = this.processPathRequestMapping("", requestMappingClass);
        String classMehodReq = this.processMethodRequestMapping(RequestMethod.GET.name(), requestMappingClass);
        RequestMapping requestMappingMethod = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
        String path = this.processPathRequestMapping(classPath, requestMappingMethod);
        String methodReq = this.processMethodRequestMapping(classMehodReq, requestMappingMethod);
        path = path.concat("#").concat(methodReq);
        if (methodAnnotation != null) {
            VersionedResource classAnnotation = (VersionedResource)AnnotationUtils.findAnnotation(method.getDeclaringClass(), VersionedResource.class);
            if (classAnnotation == null && StringUtils.isEmpty((Object)methodAnnotation.media())) {
                throw new IllegalArgumentException("Media must be declared");
            }
            PathVersionMap.INSTANCE.checkColisionPathWithVersion(path, methodAnnotation.from(), methodAnnotation.to());
            return this.createCondition(methodAnnotation.media(), methodAnnotation.from(), methodAnnotation.to(), path);
        }
        return null;
    }

    private String processMethodRequestMapping(String defaultValue, RequestMapping requestMappingMethod) {
        return requestMappingMethod == null || ArrayUtils.isEmpty((Object[])requestMappingMethod.method()) ? defaultValue : Stream.of(requestMappingMethod.method()).map(Enum::name).sorted().collect(Collectors.joining("#"));
    }

    private String processPathRequestMapping(String defaultValue, RequestMapping requestMappingMethod) {
        return requestMappingMethod == null || ArrayUtils.isEmpty((Object[])requestMappingMethod.path()) ? defaultValue : defaultValue.concat(String.join((CharSequence)"/", requestMappingMethod.path()));
    }

    private RequestCondition<?> createCondition(String media, String from, String to, String path) {
        return new VersionRequestCondition(media, from, to, path);
    }
}

