/*
 * Decompiled with CFR 0.152.
 */
package com.fintonic.versioning.configuration;

import com.fintonic.versioning.domain.PathVersionMap;
import com.fintonic.versioning.domain.VersionRange;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.condition.AbstractRequestCondition;

public class VersionRequestCondition
extends AbstractRequestCondition<VersionRequestCondition> {
    private final VersionRange version;
    private final String acceptedMediaType;
    private final String path;
    private Logger logger = LoggerFactory.getLogger(VersionRequestCondition.class);

    public VersionRequestCondition(String acceptedMediaType, String from, String to, String path) {
        this(acceptedMediaType, VersionRequestCondition.versionRange(from, to), path);
    }

    public VersionRequestCondition(String acceptedMediaType, VersionRange version, String path) {
        PathVersionMap.INSTANCE.addPathWithVersion(path, version);
        this.path = path;
        this.acceptedMediaType = acceptedMediaType;
        this.version = version;
    }

    private static VersionRange versionRange(String from, String to) {
        if (StringUtils.hasText((String)from)) {
            String toVersion = StringUtils.hasText((String)to) ? to : "99.99";
            return new VersionRange(from, toVersion);
        }
        return null;
    }

    public VersionRequestCondition combine(VersionRequestCondition other) {
        this.logger.debug("Combining:\n{}\n{}", (Object)this, (Object)other);
        if (StringUtils.hasText((String)this.acceptedMediaType) && StringUtils.hasText((String)other.acceptedMediaType) && !this.acceptedMediaType.equals(other.acceptedMediaType)) {
            throw new IllegalArgumentException("Both conditions should have the same media type. " + this.acceptedMediaType + " =!= " + other.acceptedMediaType);
        }
        String newMediaType = StringUtils.hasText((String)this.acceptedMediaType) ? this.acceptedMediaType : other.acceptedMediaType;
        if (StringUtils.isEmpty((Object)newMediaType)) {
            throw new IllegalArgumentException("Accept media type must be defined");
        }
        VersionRange version = other.version;
        if (this.version != null) {
            version = this.version;
        }
        return new VersionRequestCondition(newMediaType, version, other.path);
    }

    public VersionRequestCondition getMatchingCondition(HttpServletRequest request) {
        Pattern regexPattern;
        Matcher matcher;
        String accept = request.getHeader("Accept");
        if (!StringUtils.isEmpty((Object)accept) && this.version != null && (matcher = (regexPattern = Pattern.compile("(.*)-(v\\d+\\.\\d+).*")).matcher(accept)).matches()) {
            String actualMediaType = matcher.group(1);
            String version = matcher.group(2);
            this.logger.debug("Version={}", (Object)version);
            if (this.acceptedMediaType.startsWith(actualMediaType) && this.version.includes(version)) {
                return this;
            }
        }
        this.logger.debug("Didn't find matching version");
        return null;
    }

    public int compareTo(VersionRequestCondition other, HttpServletRequest request) {
        return 0;
    }

    protected Collection<?> getContent() {
        return Collections.singleton(this.version);
    }

    public String toString() {
        String toString = "version={";
        return toString.concat("media=").concat(this.acceptedMediaType).concat(",").concat(this.version == null ? "" : this.version.toString()).concat(",").concat("path=").concat(this.path).concat("}");
    }

    protected String getToStringInfix() {
        return " && ";
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VersionRequestCondition)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VersionRequestCondition that = (VersionRequestCondition)((Object)o);
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.acceptedMediaType != null ? !this.acceptedMediaType.equals(that.acceptedMediaType) : that.acceptedMediaType != null) {
            return false;
        }
        return this.path != null ? this.path.equals(that.path) : that.path == null;
    }
}

