/*
 * Decompiled with CFR 0.152.
 */
package com.fintonic.versioning.configuration;

import com.fintonic.versioning.annotation.VersionedResource;
import com.fintonic.versioning.configuration.VersionRequestCondition;
import com.fintonic.versioning.domain.PathVersionMap;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class VersionRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    protected RequestCondition<?> getCustomTypeCondition(Class<?> handlerType) {
        VersionedResource versionResourceAnnotation = (VersionedResource)AnnotationUtils.findAnnotation(handlerType, VersionedResource.class);
        if (versionResourceAnnotation != null) {
            if (StringUtils.isEmpty((Object)versionResourceAnnotation.media())) {
                throw new IllegalArgumentException("Media cannot be null in class annotation");
            }
            return this.createCondition(versionResourceAnnotation.media(), versionResourceAnnotation.from(), versionResourceAnnotation.to(), "");
        }
        return null;
    }

    protected RequestCondition<?> getCustomMethodCondition(Method method) {
        String path;
        VersionedResource methodAnnotation = (VersionedResource)AnnotationUtils.findAnnotation((Method)method, VersionedResource.class);
        if (methodAnnotation != null && StringUtils.isEmpty((Object)methodAnnotation.from())) {
            throw new IllegalArgumentException("From must be declared in method");
        }
        RequestMapping requestMappingClass = (RequestMapping)AnnotationUtils.findAnnotation(method.getDeclaringClass(), RequestMapping.class);
        String classPath = requestMappingClass == null ? "" : String.join((CharSequence)"/", requestMappingClass.path());
        RequestMapping requestMappingMethod = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
        String string = path = requestMappingMethod == null ? classPath : classPath.concat(String.join((CharSequence)"/", requestMappingMethod.path()));
        if (methodAnnotation != null) {
            VersionedResource classAnnotation = (VersionedResource)AnnotationUtils.findAnnotation(method.getDeclaringClass(), VersionedResource.class);
            if (classAnnotation == null && StringUtils.isEmpty((Object)methodAnnotation.media())) {
                throw new IllegalArgumentException("Media must be declared");
            }
            PathVersionMap.INSTANCE.checkColisionPathWithVersion(path, methodAnnotation.from(), methodAnnotation.to());
            return this.createCondition(methodAnnotation.media(), methodAnnotation.from(), methodAnnotation.to(), path);
        }
        return null;
    }

    private RequestCondition<?> createCondition(String media, String from, String to, String path) {
        return new VersionRequestCondition(media, from, to, path);
    }
}

