/*
 * Decompiled with CFR 0.152.
 */
package com.fintonic.versioning.domain;

import com.fintonic.versioning.domain.Version;
import org.springframework.util.StringUtils;

public class VersionRange {
    private Version from;
    private Version to;

    public VersionRange(String from, String to) {
        if (StringUtils.isEmpty((Object)from)) {
            throw new IllegalArgumentException("Define from in @VersionedResource");
        }
        this.from = new Version(from);
        this.to = new Version(to);
        if (this.from.compareTo(this.to) != -1 && this.from.compareTo(this.to) != 0) {
            throw new IllegalArgumentException("From is minor than to, bad definition");
        }
    }

    public Version getTo() {
        return this.to;
    }

    public void setTo(Version to) {
        this.to = to;
    }

    public boolean includes(String other) {
        Version otherVersion = new Version(other);
        return this.from.compareTo(otherVersion) <= 0 && this.to.compareTo(otherVersion) >= 0;
    }

    public String toString() {
        return "range[" + this.from + "-" + this.to + "]";
    }
}

