/*
 * Decompiled with CFR 0.152.
 */
package com.fintonic.versioning.domain;

import com.fintonic.versioning.domain.VersionRange;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum PathVersionMap {
    INSTANCE;

    private final Map<String, VersionRange> pathWithVersion = new ConcurrentHashMap<String, VersionRange>();

    public void addPathWithVersion(String path, VersionRange version) {
        if (path != null && version != null) {
            this.pathWithVersion.put(path, version);
        }
    }

    public void checkColisionPathWithVersion(String path, String ... versions) {
        VersionRange versionsToCheck;
        if (path != null && (versionsToCheck = this.pathWithVersion.get(path)) != null) {
            for (String version : versions) {
                if (!versionsToCheck.includes(version)) continue;
                throw new RuntimeException("Exists collision between version, path " + path + ", contains version " + version + " and " + versionsToCheck);
            }
        }
    }
}

