package com.fiftyjourney.android.lib.network.exception

import android.annotation.TargetApi
import android.os.Build
import retrofit2.Response

/**
 * @author Melody Dev
 * @since October 04, 2018.
 */
class RemoteNetworkException : Exception {

    constructor() : super()
    constructor(message: String?) : super(message)
    constructor(message: String?, cause: Throwable?) : super(message, cause)
    constructor(cause: Throwable?) : super(cause)

    @TargetApi(Build.VERSION_CODES.N)
    constructor(message: String?, cause: Throwable?, enableSuppression: Boolean, writableStackTrace: Boolean) : super(message, cause, enableSuppression, writableStackTrace)

    companion object {

        @JvmStatic
        fun parse(response: Response<*>): RemoteNetworkException {
            var msg = response.errorBody()?.string() ?: ""

            if (msg.isEmpty()) {
                msg = response.raw().networkResponse()?.message() ?: response.raw().message()
            }

            if (msg.isEmpty()) {
                msg = response.message()
            }

            if (msg.isEmpty()) {
                msg = response.toString()
            }

            return RemoteNetworkException(msg)
        }
    }
}