/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.fife.ui.rsyntaxtextarea.MarkOccurrencesHighlightPainter;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;

class MarkOccurrencesSupport
implements CaretListener,
ActionListener {
    private RSyntaxTextArea textArea;
    private Timer timer;
    private MarkOccurrencesHighlightPainter p;
    private List tags;
    public static final Color DEFAULT_COLOR = new Color(224, 224, 224);
    private static final int DEFAULT_DELAY_MS = 1000;

    public MarkOccurrencesSupport() {
        this(1000);
    }

    public MarkOccurrencesSupport(int delay) {
        this(delay, DEFAULT_COLOR);
    }

    public MarkOccurrencesSupport(int delay, Color color) {
        this.timer = new Timer(delay, this);
        this.timer.setRepeats(false);
        this.p = new MarkOccurrencesHighlightPainter();
        this.setColor(color);
        this.tags = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        Caret c = this.textArea.getCaret();
        if (c.getDot() != c.getMark()) {
            return;
        }
        RSyntaxDocument doc = (RSyntaxDocument)this.textArea.getDocument();
        doc.readLock();
        try {
            this.removeHighlights();
            int line = this.textArea.getCaretLineNumber();
            Token tokenList = this.textArea.getTokenListForLine(line);
            int dot = c.getDot();
            Token t = RSyntaxUtilities.getTokenAtOffset(tokenList, dot);
            if (t == null || !this.isValidType(t) || MarkOccurrencesSupport.isNonWordChar(t)) {
                --dot;
                try {
                    if (dot >= this.textArea.getLineStartOffset(line)) {
                        t = RSyntaxUtilities.getTokenAtOffset(tokenList, dot);
                    }
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
            if (t != null && this.isValidType(t) && !MarkOccurrencesSupport.isNonWordChar(t)) {
                RSyntaxTextAreaHighlighter h = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
                char[] lexeme = t.getLexeme().toCharArray();
                int type = t.type;
                for (int i = 0; i < this.textArea.getLineCount(); ++i) {
                    for (Token temp = this.textArea.getTokenListForLine(i); temp != null && temp.isPaintable(); temp = temp.getNextToken()) {
                        if (!temp.is(type, lexeme)) continue;
                        try {
                            int end = temp.offset + temp.textCount;
                            Object tag = h.addMarkedOccurrenceHighlight(temp.offset, end, this.p);
                            this.tags.add(tag);
                            continue;
                        }
                        catch (BadLocationException ble) {
                            ble.printStackTrace();
                        }
                    }
                }
            }
        }
        finally {
            doc.readUnlock();
        }
        this.textArea.fireMarkedOccurrencesChanged();
    }

    public void caretUpdate(CaretEvent e) {
        this.timer.restart();
    }

    public Color getColor() {
        return this.p.getColor();
    }

    public int getDelay() {
        return this.timer.getDelay();
    }

    public boolean getPaintBorder() {
        return this.p.getPaintBorder();
    }

    public void install(RSyntaxTextArea textArea) {
        if (this.textArea != null) {
            this.uninstall();
        }
        this.textArea = textArea;
        textArea.addCaretListener(this);
        if (textArea.getMarkOccurrencesColor() != null) {
            this.setColor(textArea.getMarkOccurrencesColor());
        }
    }

    private static final boolean isNonWordChar(Token t) {
        return t.textCount == 1 && !RSyntaxUtilities.isLetter(t.text[t.textOffset]);
    }

    private boolean isValidType(Token t) {
        return this.textArea.getMarkOccurrencesOfTokenType(t.type);
    }

    private void removeHighlights() {
        if (this.textArea != null) {
            RSyntaxTextAreaHighlighter h = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
            for (int i = 0; i < this.tags.size(); ++i) {
                h.removeMarkOccurrencesHighlight(this.tags.get(i));
            }
        }
        this.tags.clear();
    }

    public void setColor(Color color) {
        this.p.setColor(color);
        if (this.textArea != null) {
            this.removeHighlights();
            this.caretUpdate(null);
        }
    }

    public void setDelay(int delay) {
        this.timer.setDelay(delay);
    }

    public void setPaintBorder(boolean paint) {
        if (paint != this.p.getPaintBorder()) {
            this.p.setPaintBorder(paint);
            if (this.textArea != null) {
                this.textArea.repaint();
            }
        }
    }

    public void uninstall() {
        if (this.textArea != null) {
            this.removeHighlights();
            this.textArea.removeCaretListener(this);
        }
    }
}

