/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.TokenTypes;

public abstract class Token
implements TokenTypes {
    public char[] text = null;
    public int textOffset = -1;
    public int textCount = -1;
    public int offset = -1;
    public int type = 0;
    private boolean hyperlink = false;
    private Token nextToken = null;
    private Rectangle2D.Float bgRect = new Rectangle2D.Float();
    private static char[] tabBuf;

    public Token() {
    }

    public Token(char[] line, int beg, int end, int startOffset, int type) {
        this();
        this.set(line, beg, end, startOffset, type);
    }

    public Token(Token t2) {
        this();
        this.copyFrom(t2);
    }

    public StringBuffer appendHTMLRepresentation(StringBuffer sb, RSyntaxTextArea textArea, boolean fontFamily) {
        return this.appendHTMLRepresentation(sb, textArea, fontFamily, false);
    }

    public StringBuffer appendHTMLRepresentation(StringBuffer sb, RSyntaxTextArea textArea, boolean fontFamily, boolean tabsToSpaces) {
        SyntaxScheme colorScheme = textArea.getSyntaxScheme();
        Style scheme = colorScheme.getStyle(this.type);
        Font font = textArea.getFontForTokenType(this.type);
        if (font.isBold()) {
            sb.append("<b>");
        }
        if (font.isItalic()) {
            sb.append("<em>");
        }
        if (scheme.underline || this.isHyperlink()) {
            sb.append("<u>");
        }
        sb.append("<font");
        if (fontFamily) {
            sb.append(" face=\"").append(font.getFamily()).append("\"");
        }
        sb.append(" color=\"").append(Token.getHTMLFormatForColor(scheme.foreground)).append("\">");
        this.appendHtmlLexeme(textArea, sb, tabsToSpaces);
        sb.append("</font>");
        if (scheme.underline || this.isHyperlink()) {
            sb.append("</u>");
        }
        if (font.isItalic()) {
            sb.append("</em>");
        }
        if (font.isBold()) {
            sb.append("</b>");
        }
        return sb;
    }

    private final StringBuffer appendHtmlLexeme(RSyntaxTextArea textArea, StringBuffer sb, boolean tabsToSpaces) {
        int i;
        boolean lastWasSpace = false;
        int lastI = i = this.textOffset;
        String tabStr = null;
        while (i < this.textOffset + this.textCount) {
            char ch = this.text[i];
            switch (ch) {
                case ' ': {
                    sb.append(this.text, lastI, i - lastI);
                    lastI = i + 1;
                    sb.append(lastWasSpace ? "&nbsp;" : " ");
                    lastWasSpace = true;
                    break;
                }
                case '\t': {
                    sb.append(this.text, lastI, i - lastI);
                    lastI = i + 1;
                    if (tabsToSpaces && tabStr == null) {
                        tabStr = "";
                        for (int j = 0; j < textArea.getTabSize(); ++j) {
                            tabStr = tabStr + "&nbsp;";
                        }
                    }
                    sb.append(tabsToSpaces ? tabStr : "&#09;");
                    lastWasSpace = false;
                    break;
                }
                case '<': {
                    sb.append(this.text, lastI, i - lastI);
                    lastI = i + 1;
                    sb.append("&lt;");
                    lastWasSpace = false;
                    break;
                }
                case '>': {
                    sb.append(this.text, lastI, i - lastI);
                    lastI = i + 1;
                    sb.append("&gt;");
                    lastWasSpace = false;
                    break;
                }
                default: {
                    lastWasSpace = false;
                }
            }
            ++i;
        }
        if (lastI < this.textOffset + this.textCount) {
            sb.append(this.text, lastI, this.textOffset + this.textCount - lastI);
        }
        return sb;
    }

    public boolean containsPosition(int pos) {
        return pos >= this.offset && pos < this.offset + this.textCount;
    }

    public void copyFrom(Token t2) {
        this.text = t2.text;
        this.textOffset = t2.textOffset;
        this.textCount = t2.textCount;
        this.offset = t2.offset;
        this.type = t2.type;
        this.nextToken = t2.nextToken;
    }

    public int documentToToken(int pos) {
        return pos + (this.textOffset - this.offset);
    }

    public boolean endsWith(char[] ch) {
        if (ch == null || ch.length > this.textCount) {
            return false;
        }
        int start = this.textOffset + this.textCount - ch.length;
        for (int i = 0; i < ch.length; ++i) {
            if (this.text[start + i] == ch[i]) continue;
            return false;
        }
        return true;
    }

    private static final String getHTMLFormatForColor(Color color) {
        String hexBlue;
        String hexGreen;
        if (color == null) {
            return "black";
        }
        String hexRed = Integer.toHexString(color.getRed());
        if (hexRed.length() == 1) {
            hexRed = "0" + hexRed;
        }
        if ((hexGreen = Integer.toHexString(color.getGreen())).length() == 1) {
            hexGreen = "0" + hexGreen;
        }
        if ((hexBlue = Integer.toHexString(color.getBlue())).length() == 1) {
            hexBlue = "0" + hexBlue;
        }
        return "#" + hexRed + hexGreen + hexBlue;
    }

    public String getHTMLRepresentation(RSyntaxTextArea textArea) {
        StringBuffer buf = new StringBuffer();
        this.appendHTMLRepresentation(buf, textArea, true);
        return buf.toString();
    }

    public Token getLastNonCommentNonWhitespaceToken() {
        Token last = null;
        Token t = this;
        while (t != null && t.isPaintable()) {
            switch (t.type) {
                case 1: 
                case 2: 
                case 3: 
                case 21: {
                    break;
                }
                default: {
                    last = t;
                }
            }
            t = t.nextToken;
        }
        return last;
    }

    public Token getLastPaintableToken() {
        Token t = this;
        while (t.isPaintable()) {
            if (t.nextToken == null || !t.nextToken.isPaintable()) {
                return t;
            }
            t = t.nextToken;
        }
        return null;
    }

    public String getLexeme() {
        return new String(this.text, this.textOffset, this.textCount);
    }

    public abstract int getListOffset(RSyntaxTextArea var1, TabExpander var2, float var3, float var4);

    public Token getNextToken() {
        return this.nextToken;
    }

    public int getOffsetBeforeX(RSyntaxTextArea textArea, TabExpander e, float startX, float endBeforeX) {
        int i;
        FontMetrics fm = textArea.getFontMetricsForTokenType(this.type);
        int stop = i + this.textCount;
        float x = startX;
        for (i = this.textOffset; i < stop; ++i) {
            x = this.text[i] == '\t' ? e.nextTabStop(x, 0) : (x += (float)fm.charWidth(this.text[i]));
            if (!(x > endBeforeX)) continue;
            int intoToken = Math.max(i - this.textOffset, 1);
            return this.offset + intoToken;
        }
        return this.offset + this.textCount - 1;
    }

    public float getWidth(RSyntaxTextArea textArea, TabExpander e, float x0) {
        return this.getWidthUpTo(this.textCount, textArea, e, x0);
    }

    public abstract float getWidthUpTo(int var1, RSyntaxTextArea var2, TabExpander var3, float var4);

    public boolean is(int type, char[] lexeme) {
        if (this.type == type && this.textCount == lexeme.length) {
            for (int i = 0; i < this.textCount; ++i) {
                if (this.text[this.textOffset + i] == lexeme[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean is(int type, String lexeme) {
        return this.type == type && this.textCount == lexeme.length() && lexeme.equals(this.getLexeme());
    }

    public boolean isComment() {
        return this.type >= 1 && this.type <= 3;
    }

    public boolean isHyperlink() {
        return this.hyperlink;
    }

    public boolean isLeftCurly() {
        return this.type == 22 && this.isSingleChar('{');
    }

    public boolean isRightCurly() {
        return this.type == 22 && this.isSingleChar('}');
    }

    public boolean isPaintable() {
        return this.type > 0;
    }

    public boolean isSingleChar(char ch) {
        return this.textCount == 1 && this.text[this.textOffset] == ch;
    }

    public boolean isWhitespace() {
        return this.type == 21;
    }

    public abstract Rectangle listOffsetToView(RSyntaxTextArea var1, TabExpander var2, int var3, int var4, Rectangle var5);

    public void makeStartAt(int pos) {
        if (pos < this.offset || pos >= this.offset + this.textCount) {
            throw new IllegalArgumentException("pos " + pos + " is not in range " + this.offset + "-" + (this.offset + this.textCount - 1));
        }
        int shift = pos - this.offset;
        this.offset = pos;
        this.textOffset += shift;
        this.textCount -= shift;
    }

    public void moveOffset(int amt) {
        if (amt < 0 || amt > this.textCount) {
            throw new IllegalArgumentException("amt " + amt + " is not in range 0-" + this.textCount);
        }
        this.offset += amt;
        this.textOffset += amt;
        this.textCount -= amt;
    }

    public final float paint(Graphics2D g, float x, float y, RSyntaxTextArea host, TabExpander e) {
        return this.paint(g, x, y, host, e, 0.0f);
    }

    public abstract float paint(Graphics2D var1, float var2, float var3, RSyntaxTextArea var4, TabExpander var5, float var6);

    protected void paintBackground(float x, float y, float width, float height, Graphics2D g, int fontAscent, RSyntaxTextArea host, Color color) {
        Color temp = host.getBackground();
        g.setXORMode(temp != null ? temp : Color.WHITE);
        g.setColor(color);
        this.bgRect.setRect(x, y - (float)fontAscent, width, height);
        g.fill(this.bgRect);
        g.setPaintMode();
    }

    protected void paintTabLines(int x, int y, int endX, Graphics2D g, TabExpander e, RSyntaxTextArea host) {
        if (this.type != 21) {
            int offs;
            for (offs = this.textOffset; offs < this.textOffset + this.textCount && RSyntaxUtilities.isWhitespace(this.text[offs]); ++offs) {
            }
            int len = offs - this.textOffset;
            if (len < 2) {
                return;
            }
            endX = (int)this.getWidthUpTo(len, host, e, 0.0f);
        }
        FontMetrics fm = host.getFontMetricsForTokenType(this.type);
        int tabSize = host.getTabSize();
        if (tabBuf == null || tabBuf.length < tabSize) {
            tabBuf = new char[tabSize];
            for (int i = 0; i < tabSize; ++i) {
                Token.tabBuf[i] = 32;
            }
        }
        int tabW = fm.charsWidth(tabBuf, 0, tabSize);
        g.setColor(host.getTabLineColor());
        int x0 = x + tabW;
        int y0 = y - fm.getAscent();
        if ((y0 & 1) > 0) {
            ++y0;
        }
        while (x0 < endX) {
            int y2 = y0 + host.getLineHeight();
            for (int y1 = y0; y1 < y2; y1 += 2) {
                g.drawLine(x0, y1, x0, y1);
            }
            x0 += tabW;
        }
    }

    public void set(char[] line, int beg, int end, int offset, int type) {
        this.text = line;
        this.textOffset = beg;
        this.textCount = end - beg + 1;
        this.type = type;
        this.offset = offset;
        this.nextToken = null;
    }

    public void setHyperlink(boolean hyperlink) {
        this.hyperlink = hyperlink;
    }

    public void setNextToken(Token nextToken) {
        this.nextToken = nextToken;
    }

    public int tokenToDocument(int pos) {
        return pos + (this.offset - this.textOffset);
    }

    public String toString() {
        return "[Token: " + (this.type == 0 ? "<null token>" : "text: '" + (this.text == null ? "<null>" : this.getLexeme() + "'; " + "offset: " + this.offset + "; type: " + this.type + "; " + "isPaintable: " + this.isPaintable() + "; nextToken==null: " + (this.nextToken == null))) + "]";
    }
}

