/*
 * Decompiled with CFR 0.152.
 */
package com.fernandocejas.frodo.joinpoint;

import android.os.Looper;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;

public class FrodoJoinPoint {
    private final JoinPoint joinPoint;
    private final MethodSignature methodSignature;
    private final String classCanonicalName;
    private final String classSimpleName;
    private final String methodName;
    private final List<Class> methodParamTypesList;
    private final List<String> methodParamNamesList;
    private final List<Object> methodParamValuesList;
    private final String executionThreadName;
    private final String joinPointUniqueName;

    public FrodoJoinPoint(JoinPoint joinPoint) {
        if (joinPoint == null) {
            throw new IllegalArgumentException("Constructor parameters cannot be null!!!");
        }
        this.joinPoint = joinPoint;
        this.methodSignature = (MethodSignature)this.joinPoint.getSignature();
        this.classCanonicalName = this.methodSignature.getDeclaringType().getCanonicalName();
        this.classSimpleName = this.methodSignature.getDeclaringType().getSimpleName();
        this.methodName = this.methodSignature.getName();
        this.executionThreadName = Thread.currentThread().getName();
        Class[] parameterTypes = this.methodSignature.getParameterTypes();
        String[] parameterNames = this.methodSignature.getParameterNames();
        Object[] args = this.joinPoint.getArgs();
        this.methodParamTypesList = parameterTypes != null ? Arrays.asList(parameterTypes) : Collections.emptyList();
        this.methodParamNamesList = parameterNames != null ? Arrays.asList(parameterNames) : Collections.emptyList();
        this.methodParamValuesList = args != null ? Arrays.asList(args) : Collections.emptyList();
        this.joinPointUniqueName = this.generateJoinPointUniqueName();
    }

    public String getClassSimpleName() {
        return this.classSimpleName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<Class> getMethodParamTypesList() {
        return this.methodParamTypesList;
    }

    public List<String> getMethodParamNamesList() {
        return this.methodParamNamesList;
    }

    public List<Object> getMethodParamValuesList() {
        return this.methodParamValuesList;
    }

    public String getExecutionThreadName() {
        return this.executionThreadName;
    }

    public Annotation getAnnotation(Class<? extends Annotation> annotation) {
        return this.methodSignature.getMethod().getAnnotation(annotation);
    }

    public boolean isMainThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }

    public boolean hasReturnType(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        return signature instanceof MethodSignature && ((MethodSignature)signature).getReturnType() != Void.TYPE;
    }

    public Class getReturnType() {
        return this.methodSignature.getReturnType();
    }

    public List<Class> getGenericReturnTypes() {
        Type returnType = this.methodSignature.getMethod().getGenericReturnType();
        if (returnType instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)returnType).getActualTypeArguments();
            ArrayList<Class> genericReturnTypes = new ArrayList<Class>(typeArguments.length);
            for (Type typeArgument : typeArguments) {
                genericReturnTypes.add(typeArgument.getClass());
            }
            return genericReturnTypes;
        }
        Class clazz = (Class)returnType;
        return Collections.singletonList(clazz);
    }

    public Object getTarget() {
        return this.joinPoint.getTarget();
    }

    public JoinPoint getJoinPoint() {
        return this.joinPoint;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        FrodoJoinPoint joinPoint = (FrodoJoinPoint)object;
        return this.joinPointUniqueName.equals(joinPoint.joinPointUniqueName);
    }

    public int hashCode() {
        return this.joinPointUniqueName.hashCode();
    }

    private String generateJoinPointUniqueName() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(this.classCanonicalName);
        stringBuilder.append(".");
        stringBuilder.append(this.methodName);
        stringBuilder.append("(");
        if (!this.methodParamNamesList.isEmpty()) {
            for (int i = 0; i < this.methodParamNamesList.size(); ++i) {
                stringBuilder.append(this.methodParamTypesList.get(i).getSimpleName());
                stringBuilder.append(" ");
                stringBuilder.append(this.methodParamNamesList.get(i));
                if (i == this.methodParamNamesList.size() - 1) continue;
                stringBuilder.append(", ");
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

