/*
 * Decompiled with CFR 0.152.
 */
package com.fernandocejas.frodo.internal.observable;

import com.fernandocejas.frodo.core.optional.Optional;
import com.fernandocejas.frodo.joinpoint.FrodoJoinPoint;

public class ObservableInfo {
    private final FrodoJoinPoint joinPoint;
    private String subscribeOnThread;
    private String observeOnThread;
    private long totalExecutionTime;
    private int totalEmittedItems;

    public ObservableInfo(FrodoJoinPoint joinPoint) {
        this.joinPoint = joinPoint;
    }

    public String getClassSimpleName() {
        return this.joinPoint.getClassSimpleName();
    }

    public String getMethodName() {
        return this.joinPoint.getMethodName();
    }

    public FrodoJoinPoint getJoinPoint() {
        return this.joinPoint;
    }

    public Optional<String> getSubscribeOnThread() {
        return Optional.fromNullable(this.subscribeOnThread);
    }

    public Optional<String> getObserveOnThread() {
        return Optional.fromNullable(this.observeOnThread);
    }

    public Optional<Long> getTotalExecutionTime() {
        if (this.totalExecutionTime == 0L) {
            return Optional.absent();
        }
        return Optional.of(this.totalExecutionTime);
    }

    public Optional<Integer> getTotalEmittedItems() {
        if (this.totalEmittedItems == 0) {
            return Optional.absent();
        }
        return Optional.of(this.totalEmittedItems);
    }

    void setSubscribeOnThread(String subscribeOnThread) {
        this.subscribeOnThread = subscribeOnThread;
    }

    void setObserveOnThread(String observeOnThread) {
        this.observeOnThread = observeOnThread;
    }

    void setTotalExecutionTime(long totalExecutionTime) {
        this.totalExecutionTime = totalExecutionTime;
    }

    void setTotalEmittedItems(int totalEmittedItems) {
        this.totalEmittedItems = totalEmittedItems;
    }
}

