/*
 * Decompiled with CFR 0.152.
 */
package com.fernandocejas.frodo.internal.observable;

import com.fernandocejas.frodo.internal.Counter;
import com.fernandocejas.frodo.internal.MessageManager;
import com.fernandocejas.frodo.internal.StopWatch;
import com.fernandocejas.frodo.internal.observable.LoggableObservable;
import com.fernandocejas.frodo.internal.observable.ObservableInfo;
import com.fernandocejas.frodo.joinpoint.FrodoProceedingJoinPoint;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Action1;

class LogStreamObservable
extends LoggableObservable {
    LogStreamObservable(FrodoProceedingJoinPoint joinPoint, MessageManager messageManager, ObservableInfo observableInfo) {
        super(joinPoint, messageManager, observableInfo);
    }

    @Override
    <T> Observable<T> get(T type) throws Throwable {
        final StopWatch stopWatch = new StopWatch();
        final Counter emittedItems = new Counter(this.joinPoint.getMethodName());
        return ((Observable)this.joinPoint.proceed()).doOnSubscribe(new Action0(){

            public void call() {
                stopWatch.start();
            }
        }).doOnNext(new Action1<T>(){

            public void call(T value) {
                emittedItems.increment();
                LogStreamObservable.this.messageManager.printObservableOnNextWithValue(LogStreamObservable.this.observableInfo, value);
            }
        }).doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                LogStreamObservable.this.messageManager.printObservableOnError(LogStreamObservable.this.observableInfo, throwable);
            }
        }).doOnTerminate(new Action0(){

            public void call() {
                stopWatch.stop();
                LogStreamObservable.this.observableInfo.setTotalExecutionTime(stopWatch.getTotalTimeMillis());
                LogStreamObservable.this.observableInfo.setTotalEmittedItems(emittedItems.tally());
                LogStreamObservable.this.messageManager.printObservableItemTimeInfo(LogStreamObservable.this.observableInfo);
            }
        });
    }
}

