/*
 * Decompiled with CFR 0.152.
 */
package com.fernandocejas.frodo.internal.observable;

import com.fernandocejas.frodo.internal.Counter;
import com.fernandocejas.frodo.internal.MessageManager;
import com.fernandocejas.frodo.internal.StopWatch;
import com.fernandocejas.frodo.internal.observable.LoggableObservable;
import com.fernandocejas.frodo.internal.observable.ObservableInfo;
import com.fernandocejas.frodo.joinpoint.FrodoProceedingJoinPoint;
import rx.Notification;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Action1;

class LogEverythingObservable
extends LoggableObservable {
    LogEverythingObservable(FrodoProceedingJoinPoint joinPoint, MessageManager messageManager, ObservableInfo observableInfo) {
        super(joinPoint, messageManager, observableInfo);
    }

    @Override
    <T> Observable<T> get(T type) throws Throwable {
        final StopWatch stopWatch = new StopWatch();
        final Counter emittedItems = new Counter(this.joinPoint.getMethodName());
        return ((Observable)this.joinPoint.proceed()).doOnSubscribe(new Action0(){

            public void call() {
                stopWatch.start();
                LogEverythingObservable.this.messageManager.printObservableOnSubscribe(LogEverythingObservable.this.observableInfo);
            }
        }).doOnEach(new Action1<Notification<? super T>>(){

            public void call(Notification<? super T> notification) {
                if (!LogEverythingObservable.this.observableInfo.getSubscribeOnThread().isPresent() && (notification.isOnNext() || notification.isOnError())) {
                    LogEverythingObservable.this.observableInfo.setSubscribeOnThread(Thread.currentThread().getName());
                }
            }
        }).doOnNext(new Action1<T>(){

            public void call(T value) {
                emittedItems.increment();
                LogEverythingObservable.this.messageManager.printObservableOnNextWithValue(LogEverythingObservable.this.observableInfo, value);
            }
        }).doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                LogEverythingObservable.this.messageManager.printObservableOnError(LogEverythingObservable.this.observableInfo, throwable);
            }
        }).doOnCompleted(new Action0(){

            public void call() {
                LogEverythingObservable.this.messageManager.printObservableOnCompleted(LogEverythingObservable.this.observableInfo);
            }
        }).doOnTerminate(new Action0(){

            public void call() {
                stopWatch.stop();
                LogEverythingObservable.this.observableInfo.setTotalExecutionTime(stopWatch.getTotalTimeMillis());
                LogEverythingObservable.this.observableInfo.setTotalEmittedItems(emittedItems.tally());
                LogEverythingObservable.this.messageManager.printObservableOnTerminate(LogEverythingObservable.this.observableInfo);
                LogEverythingObservable.this.messageManager.printObservableItemTimeInfo(LogEverythingObservable.this.observableInfo);
            }
        }).doOnUnsubscribe(new Action0(){

            public void call() {
                if (!LogEverythingObservable.this.observableInfo.getObserveOnThread().isPresent()) {
                    LogEverythingObservable.this.observableInfo.setObserveOnThread(Thread.currentThread().getName());
                }
                LogEverythingObservable.this.messageManager.printObservableThreadInfo(LogEverythingObservable.this.observableInfo);
                LogEverythingObservable.this.messageManager.printObservableOnUnsubscribe(LogEverythingObservable.this.observableInfo);
            }
        });
    }
}

