/*
 * Decompiled with CFR 0.152.
 */
package com.fernandocejas.frodo.internal.observable;

import com.fernandocejas.frodo.annotation.RxLogObservable;
import com.fernandocejas.frodo.internal.MessageManager;
import com.fernandocejas.frodo.internal.observable.LoggableObservableFactory;
import com.fernandocejas.frodo.internal.observable.ObservableInfo;
import com.fernandocejas.frodo.joinpoint.FrodoProceedingJoinPoint;
import java.lang.annotation.Annotation;
import rx.Observable;

public class FrodoObservable {
    private final FrodoProceedingJoinPoint joinPoint;
    private final MessageManager messageManager;
    private final ObservableInfo observableInfo;
    private final LoggableObservableFactory observableFactory;
    private String observeOnThread = "";

    public FrodoObservable(FrodoProceedingJoinPoint joinPoint, MessageManager messageManager, LoggableObservableFactory observableFactory) {
        this.joinPoint = joinPoint;
        this.messageManager = messageManager;
        this.observableInfo = new ObservableInfo(joinPoint);
        this.observableFactory = observableFactory;
    }

    public Observable getObservable() throws Throwable {
        this.messageManager.printObservableInfo(this.observableInfo);
        Class observableType = this.joinPoint.getGenericReturnTypes().get(0);
        Annotation annotation = this.joinPoint.getAnnotation(RxLogObservable.class);
        return this.observableFactory.create(annotation).get(observableType);
    }
}

