/*
 * Decompiled with CFR 0.152.
 */
package com.fernandocejas.frodo.core.strings;

import com.fernandocejas.frodo.core.strings.Joiner;
import java.math.BigInteger;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public final class Strings {
    public static final String EMPTY = "";

    public static String nullToEmpty(@Nullable CharSequence string) {
        return string == null ? EMPTY : string.toString();
    }

    public static boolean isNullOrEmpty(@Nullable CharSequence string) {
        return string == null || string.length() == 0;
    }

    public static boolean isBlank(@Nullable CharSequence string) {
        return Strings.isNullOrEmpty(Strings.nullToEmpty(string).trim());
    }

    public static boolean isNotBlank(@Nullable CharSequence string) {
        return !Strings.isBlank(string);
    }

    public static String safeToString(@Nullable Object object) {
        return object == null ? EMPTY : object.toString();
    }

    public static String toHexString(byte[] bytes) {
        return String.format(Locale.US, "%0" + (bytes.length << 1) + "x", new BigInteger(1, bytes));
    }

    public static Joiner joinOn(String separator) {
        return new Joiner(separator);
    }

    public static Joiner joinOn(char separator) {
        return new Joiner(String.valueOf(separator));
    }

    private Strings() {
    }
}

