/*
 * Decompiled with CFR 0.152.
 */
package com.fernandocejas.frodo.core.optional;

import com.fernandocejas.frodo.core.checks.Preconditions;
import com.fernandocejas.frodo.core.functions.Function;
import com.fernandocejas.frodo.core.optional.Optional;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

final class Absent<T>
extends Optional<T> {
    private static final long serialVersionUID = 0L;
    static final Absent<Object> INSTANCE = new Absent();

    static <T> Optional<T> withType() {
        return INSTANCE;
    }

    private Absent() {
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public T get() {
        throw new IllegalStateException("Optional.get() cannot be called on an absent value");
    }

    @Override
    public T or(T defaultValue) {
        return Preconditions.checkNotNull(defaultValue, "use Optional.orNull() instead of Optional.or(null)");
    }

    @Override
    public Optional<T> or(Optional<? extends T> secondChoice) {
        return Preconditions.checkNotNull(secondChoice);
    }

    @Override
    @Nullable
    public T orNull() {
        return null;
    }

    @Override
    public Set<T> asSet() {
        return Collections.emptySet();
    }

    @Override
    public <V> Optional<V> transform(Function<? super T, V> function) {
        Preconditions.checkNotNull(function);
        return Absent.absent();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return object == this;
    }

    @Override
    public int hashCode() {
        return 1502476572;
    }

    @Override
    public String toString() {
        return "Optional.absent()";
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

