/*
 * Decompiled with CFR 0.152.
 */
package com.fernandocejas.frodo.core.functions;

import com.fernandocejas.frodo.core.checks.Preconditions;
import com.fernandocejas.frodo.core.functions.Function;
import com.fernandocejas.frodo.core.objects.MoreObjects;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public final class Functions {
    public static Function<Object, String> toStringFunction() {
        return ToStringFunction.INSTANCE;
    }

    public static <E> Function<E, E> identity() {
        return IdentityFunction.INSTANCE;
    }

    public static <E> Function<Object, E> constant(@Nullable E value) {
        return new ConstantFunction<E>(value);
    }

    private Functions() {
    }

    private static class ConstantFunction<E>
    implements Function<Object, E>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final E value;

        public ConstantFunction(@Nullable E value) {
            this.value = value;
        }

        @Override
        public E apply(Object from) {
            Preconditions.checkNotNull(from);
            return this.value;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (obj instanceof ConstantFunction) {
                ConstantFunction that = (ConstantFunction)obj;
                return MoreObjects.equal(this.value, that.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        public String toString() {
            return "constant(" + this.value + ")";
        }
    }

    private static enum IdentityFunction implements Function<Object, Object>
    {
        INSTANCE;


        @Override
        public Object apply(Object o) {
            Preconditions.checkNotNull(o);
            return o;
        }

        public String toString() {
            return "identity";
        }
    }

    private static enum ToStringFunction implements Function<Object, String>
    {
        INSTANCE;


        @Override
        public String apply(Object o) {
            if (o != null) {
                return o.toString();
            }
            throw new NullPointerException();
        }

        public String toString() {
            return "toString";
        }
    }
}

