/*
 * Decompiled with CFR 0.152.
 */
package com.fernandocejas.frodo.internal;

import java.util.concurrent.atomic.AtomicInteger;

public class Counter
implements Comparable<Counter> {
    private final String name;
    private final AtomicInteger count;

    public Counter() {
        this(Counter.class.getSimpleName());
    }

    public Counter(String name) {
        this.name = name;
        this.count = new AtomicInteger(0);
    }

    public void increment() {
        this.count.incrementAndGet();
    }

    public void decrement() {
        this.count.decrementAndGet();
    }

    public int tally() {
        return this.count.intValue();
    }

    public void clear() {
        this.count.set(0);
    }

    @Override
    public int compareTo(Counter that) {
        int thatValue;
        int thisValue = this.count.intValue();
        if (thisValue < (thatValue = that.count.intValue())) {
            return -1;
        }
        if (thisValue > thatValue) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " name: " + this.name + " value: " + this.count.intValue();
    }
}

