/*
 * Decompiled with CFR 0.152.
 */
package com.fernandocejas.frodo.aspect;

import com.fernandocejas.frodo.internal.Counter;
import com.fernandocejas.frodo.internal.MessageManager;
import com.fernandocejas.frodo.internal.StopWatch;
import com.fernandocejas.frodo.joinpoint.FrodoJoinPoint;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import rx.Subscriber;

@Aspect
public class LogSubscriber {
    private static final String CLASS = "within(@com.fernandocejas.frodo.annotation.RxLogSubscriber *) && if()";
    private static final String METHOD_ON_START = "execution(void *.onStart())";
    private static final String METHOD_ON_NEXT = "execution(void *.onNext(..))";
    private static final String METHOD_ON_ERROR = "execution(void *.onError(java.lang.Throwable)) && args(throwable)";
    private static final String METHOD_ON_COMPLETED = "execution(void *.onCompleted())";
    private static final String METHOD_REQUEST = "call(void *.request(long)) && args(numberOfItems)";
    private static final String METHOD_UN_SUBSCRIBE = "call(void *.unsubscribe())";
    private final Counter counter;
    private final StopWatch stopWatch;
    private final MessageManager messageManager;
    private boolean isFirstElementEmitted = true;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ LogSubscriber ajc$perSingletonInstance;

    public LogSubscriber() {
        this(new Counter(), new StopWatch(), new MessageManager());
    }

    public LogSubscriber(Counter counter, StopWatch stopWatch, MessageManager messageManager) {
        this.counter = counter;
        this.stopWatch = stopWatch;
        this.messageManager = messageManager;
    }

    @Pointcut(value="within(@com.fernandocejas.frodo.annotation.RxLogSubscriber *) && if()")
    public static boolean classAnnotatedWithRxLogSubscriber(JoinPoint joinPoint) {
        return joinPoint.getTarget() instanceof Subscriber;
    }

    @Pointcut(value="execution(void *.onStart())")
    public void onStartMethodExecution() {
    }

    @Pointcut(value="execution(void *.onNext(..))")
    public void onNextMethodExecution() {
    }

    @Pointcut(value="execution(void *.onError(java.lang.Throwable)) && args(throwable)")
    public void onErrorMethodExecution(Throwable throwable) {
    }

    @Pointcut(value="execution(void *.onCompleted())")
    public void onCompletedMethodExecution() {
    }

    @Pointcut(value="call(void *.request(long)) && args(numberOfItems)")
    public void onRequestMethodCall(long numberOfItems) {
    }

    @Pointcut(value="call(void *.unsubscribe())")
    public void onUnsubscribeMethodCall() {
    }

    @Before(value="classAnnotatedWithRxLogSubscriber(joinPoint) && onStartMethodExecution()")
    public void beforeOnStartExecution(JoinPoint joinPoint) {
        this.messageManager.printSubscriberOnStart(joinPoint.getTarget().getClass().getSimpleName());
    }

    @Before(value="classAnnotatedWithRxLogSubscriber(joinPoint) && onNextMethodExecution()")
    public void beforeOnNextExecution(JoinPoint joinPoint) {
        this.countAndMeasureTime();
        FrodoJoinPoint frodoJoinPoint = new FrodoJoinPoint(joinPoint);
        Object value = frodoJoinPoint.getMethodParamValuesList().get(0);
        this.messageManager.printSubscriberOnNext(joinPoint.getTarget().getClass().getSimpleName(), value.toString(), Thread.currentThread().getName());
    }

    @After(value="classAnnotatedWithRxLogSubscriber(joinPoint) && onErrorMethodExecution(throwable)", argNames="joinPoint,throwable")
    public void afterOnErrorExecution(JoinPoint joinPoint, Throwable throwable) {
        this.stopWatch.stop();
        this.messageManager.printSubscriberOnError(joinPoint.getTarget().getClass().getSimpleName(), throwable.toString(), this.stopWatch.getTotalTimeMillis(), this.counter.tally());
        this.resetCounters();
    }

    @Before(value="classAnnotatedWithRxLogSubscriber(joinPoint) && onCompletedMethodExecution()")
    public void beforeOnCompletedExecution(JoinPoint joinPoint) {
        this.stopWatch.stop();
        this.messageManager.printSubscriberOnCompleted(joinPoint.getTarget().getClass().getSimpleName(), this.stopWatch.getTotalTimeMillis(), this.counter.tally());
        this.resetCounters();
    }

    @After(value="classAnnotatedWithRxLogSubscriber(joinPoint) && onUnsubscribeMethodCall()")
    public void afterUnsubscribeMethodCall(JoinPoint joinPoint) {
        this.messageManager.printSubscriberUnsubscribe(joinPoint.getTarget().getClass().getSimpleName());
    }

    @After(value="classAnnotatedWithRxLogSubscriber(joinPoint) && onRequestMethodCall(numberOfItems)")
    public void afterRequestMethodCall(JoinPoint joinPoint, long numberOfItems) {
        this.messageManager.printSubscriberRequestedItems(joinPoint.getTarget().getClass().getSimpleName(), numberOfItems);
    }

    private void countAndMeasureTime() {
        this.counter.increment();
        if (this.isFirstElementEmitted) {
            this.stopWatch.start();
        }
        this.isFirstElementEmitted = false;
    }

    private void resetCounters() {
        this.isFirstElementEmitted = true;
        this.counter.clear();
        this.stopWatch.reset();
    }

    public static LogSubscriber aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.fernandocejas.frodo.aspect.LogSubscriber", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            LogSubscriber.ajc$perSingletonInstance = new LogSubscriber();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

