/*
 * Decompiled with CFR 0.152.
 */
package com.fernandocejas.frodo.internal;

import com.fernandocejas.frodo.internal.Counter;
import com.fernandocejas.frodo.internal.MessageManager;
import com.fernandocejas.frodo.internal.StopWatch;
import com.fernandocejas.frodo.joinpoint.FrodoJoinPoint;
import com.fernandocejas.frodo.joinpoint.FrodoProceedingJoinPoint;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Action1;

public class FrodoObservable {
    private final FrodoProceedingJoinPoint joinPoint;
    private final MessageManager messageManager;
    private final ObservableInfo observableInfo;

    public FrodoObservable(FrodoProceedingJoinPoint joinPoint, MessageManager messageManager) {
        this.joinPoint = joinPoint;
        this.messageManager = messageManager;
        this.observableInfo = new ObservableInfo(joinPoint);
    }

    public Observable getObservable() throws Throwable {
        this.messageManager.printObservableInfo(this.observableInfo);
        return this.logObservable(this.joinPoint.getGenericReturnTypes().get(0));
    }

    private <T> Observable<T> logObservable(T type) throws Throwable {
        final StopWatch stopWatch = new StopWatch();
        final Counter emittedElements = new Counter(this.joinPoint.getMethodName());
        return ((Observable)this.joinPoint.proceed()).doOnSubscribe(new Action0(){

            public void call() {
                stopWatch.start();
                FrodoObservable.this.messageManager.printObservableOnSubscribe(FrodoObservable.this.observableInfo, Thread.currentThread().getName());
            }
        }).doOnNext(new Action1<T>(){

            public void call(T value) {
                emittedElements.increment();
                FrodoObservable.this.messageManager.printObservableOnNext(FrodoObservable.this.observableInfo, value);
            }
        }).doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                FrodoObservable.this.messageManager.printObservableOnError(FrodoObservable.this.observableInfo, throwable);
            }
        }).doOnCompleted(new Action0(){

            public void call() {
                FrodoObservable.this.messageManager.printObservableOnCompleted(FrodoObservable.this.observableInfo);
            }
        }).doOnUnsubscribe(new Action0(){

            public void call() {
                FrodoObservable.this.messageManager.printObservableOnUnsubscribe(FrodoObservable.this.observableInfo, Thread.currentThread().getName());
            }
        }).doOnTerminate(new Action0(){

            public void call() {
                stopWatch.stop();
                FrodoObservable.this.messageManager.printObservableOnTerminate(FrodoObservable.this.observableInfo, stopWatch.getTotalTimeMillis(), emittedElements.tally());
            }
        });
    }

    class ObservableInfo {
        private final FrodoJoinPoint joinPoint;

        ObservableInfo(FrodoJoinPoint joinPoint) {
            this.joinPoint = joinPoint;
        }

        String getClassSimpleName() {
            return this.joinPoint.getClassSimpleName();
        }

        String getMethodName() {
            return this.joinPoint.getMethodName();
        }

        public FrodoJoinPoint getJoinPoint() {
            return this.joinPoint;
        }
    }
}

