/*
 * Decompiled with CFR 0.152.
 */
package com.feed.sdk.push.net;

import com.feed.sdk.push.net.ResponseListener;
import java.net.URLEncoder;
import java.util.Map;

public class Request {
    public static final int REQUEST_GET = 0;
    public static final int REQUEST_POST = 1;
    public static final int REQUEST_IMAGE = 2;
    private int method;
    private ResponseListener listener;
    private Map<String, String> params;
    private String url;
    private Map<String, String> headers;

    public Request(String url, int method, Map<String, String> params, ResponseListener listener) {
        this.url = url;
        this.method = method;
        this.params = params;
        this.listener = listener;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public int getRequestMethod() {
        return this.method;
    }

    public String getRequestHTTPMethod() {
        switch (this.method) {
            case 0: 
            case 2: {
                return "GET";
            }
        }
        return "POST";
    }

    public String getRequestUrl() {
        return this.url;
    }

    private String getPostParams() {
        String rtn = "";
        for (String key : this.params.keySet()) {
            try {
                rtn = rtn + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(this.params.get(key), "UTF-8") + "&";
            }
            catch (Exception exception) {}
        }
        return rtn;
    }

    public String getPostData() {
        return this.getPostParams();
    }

    public ResponseListener getListener() {
        return this.listener;
    }
}

