/*
 * Decompiled with CFR 0.152.
 */
package com.feed.sdk.push.net;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.ConnectivityManager;
import android.os.Handler;
import android.os.Looper;
import com.feed.sdk.push.common.Logs;
import com.feed.sdk.push.net.Request;
import com.feed.sdk.push.net.Response;
import com.feed.sdk.push.net.ResponseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;

public class FeedNet {
    private Context ctx;

    private FeedNet(Context ctx) {
        this.ctx = ctx;
    }

    public static FeedNet getInstance(Context ctx) {
        return new FeedNet(ctx);
    }

    public void executeRequest(final Request request) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                switch (request.getRequestMethod()) {
                    case 0: {
                        FeedNet.this.processGet(request);
                        break;
                    }
                    case 1: {
                        FeedNet.this.processPost(request);
                        break;
                    }
                    case 2: {
                        FeedNet.this.processGetImage(request);
                    }
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGetImage(Request request) {
        if (!this.isNetworkAvailable()) {
            Response resp = new Response(true, "Network not available", "");
            this.sendResponse(request.getListener(), resp);
            return;
        }
        try {
            URL url = new URL(request.getRequestUrl());
            URLConnection urlConn = url.openConnection();
            InputStream in = urlConn.getInputStream();
            Bitmap data = this.getBitmap(in);
            in.close();
            Response resp = new Response(false, null, data);
            this.sendResponse(request.getListener(), resp);
        }
        catch (Exception ex) {
            Response resp = new Response(true, "There seems to be some problem with your network. Please try again after some time.", "");
            this.sendResponse(request.getListener(), resp);
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGet(Request request) {
        if (!this.isNetworkAvailable()) {
            Response resp = new Response(true, "Network not available", "");
            this.sendResponse(request.getListener(), resp);
            return;
        }
        HttpURLConnection con = this.getHttpURLConnection(request);
        if (con != null) {
            try {
                if (con.getResponseCode() == 200) {
                    InputStream in = con.getInputStream();
                    int code = con.getResponseCode();
                    String data = this.getData(in);
                    Response resp = new Response(false, null, data);
                    this.sendResponse(request.getListener(), resp);
                } else {
                    Response resp = new Response(true, "Invalid response code", "");
                    this.sendResponse(request.getListener(), resp);
                }
            }
            catch (Exception ex) {
                Response resp = new Response(true, "There seems to be some problem with your network. Please try again after some time.", "");
                this.sendResponse(request.getListener(), resp);
                ex.printStackTrace();
            }
            finally {
                try {
                    if (con != null) {
                        con.disconnect();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.ctx.getSystemService("connectivity");
        return cm.getActiveNetworkInfo() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPost(Request request) {
        if (!this.isNetworkAvailable()) {
            Response resp = new Response(true, "Network not available", "");
            this.sendResponse(request.getListener(), resp);
            return;
        }
        HttpURLConnection con = this.getHttpURLConnection(request);
        if (con != null) {
            try {
                OutputStream out = con.getOutputStream();
                out.write(request.getPostData().getBytes());
                out.flush();
                if (con.getResponseCode() == 200) {
                    InputStream in = con.getInputStream();
                    String data = this.getData(in);
                    Response resp = new Response(false, null, data);
                    this.sendResponse(request.getListener(), resp);
                } else {
                    Response resp = new Response(true, "Invalid response code", "");
                    this.sendResponse(request.getListener(), resp);
                }
            }
            catch (Exception ex) {
                Response resp = new Response(true, "There seems to be some problem with your network. Please try again after some time.", "");
                this.sendResponse(request.getListener(), resp);
            }
            finally {
                try {
                    if (con != null) {
                        con.disconnect();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private HttpURLConnection getHttpURLConnection(Request req) {
        try {
            String resourceURL = req.getRequestUrl();
            URL url = new URL(req.getRequestUrl());
            HttpURLConnection con = null;
            con = resourceURL.toLowerCase().indexOf("https") != -1 ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
            con.setRequestMethod(req.getRequestHTTPMethod());
            Map<String, String> headers = req.getHeaders();
            if (headers != null) {
                Set<String> keys = headers.keySet();
                for (String key : keys) {
                    con.addRequestProperty(key, headers.get(key));
                }
            }
            con.setDoInput(true);
            con.setDoOutput(true);
            return con;
        }
        catch (MalformedURLException exp) {
            Logs.e(exp.getMessage());
        }
        catch (IOException ex) {
            Logs.e(ex.getMessage());
        }
        return null;
    }

    private String getData(InputStream in) throws Exception {
        if (in == null) {
            throw new Exception("Input stream can not be null");
        }
        int c = -1;
        StringBuffer r = new StringBuffer();
        try {
            InputStreamReader isr = new InputStreamReader(in, "UTF-8");
            BufferedReader reader = new BufferedReader(isr);
            String line = null;
            while ((line = reader.readLine()) != null) {
                r.append(line);
            }
            isr.close();
            reader.close();
            return r.toString();
        }
        catch (Exception e) {
            throw new Exception("Error while reading response");
        }
    }

    private Bitmap getBitmap(InputStream in) throws Exception {
        if (in == null) {
            throw new Exception("Input stream can not be null");
        }
        int c = -1;
        StringBuffer r = new StringBuffer();
        try {
            return BitmapFactory.decodeStream((InputStream)in);
        }
        catch (Exception e) {
            throw new Exception("Error while reading response");
        }
    }

    private void sendResponse(final ResponseListener listener, final Response resp) {
        if (listener != null) {
            long threadId = Thread.currentThread().getId();
            if (Looper.myLooper() != Looper.getMainLooper()) {
                Handler mainThread = new Handler(Looper.getMainLooper());
                mainThread.post(new Runnable(){

                    @Override
                    public void run() {
                        listener.onResponse(resp);
                    }
                });
                return;
            }
            listener.onResponse(resp);
        }
    }
}

