/*
 * Decompiled with CFR 0.152.
 */
package com.feed.sdk.push.common;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import com.feed.sdk.push.common.Logs;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Cache {
    public static void save_bitmap(Context context, String key, Bitmap bitmap) {
        key = Base64.encodeToString((byte[])key.getBytes(), (int)0);
        Logs.e("=========key====save======", key);
        if (bitmap != null) {
            File cacheDir = context.getCacheDir();
            File file = new File(cacheDir, key);
            try {
                FileOutputStream out = new FileOutputStream(file);
                bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)out);
                out.flush();
                out.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Bitmap getBitmap(Context context, String key) {
        key = Base64.encodeToString((byte[])key.getBytes(), (int)0);
        Logs.e("=========key====take======", key);
        File cacheDir = context.getCacheDir();
        File file = new File(cacheDir, key);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (fis != null) {
            return BitmapFactory.decodeStream((InputStream)fis);
        }
        return null;
    }

    public static long getLastModified(Context context, String key) {
        return new File(context.getCacheDir(), key).lastModified();
    }

    public static void deleteCache(Context context) {
        try {
            File dir = context.getCacheDir();
            if (dir != null && dir.isDirectory()) {
                Cache.deleteDir(dir);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir != null && dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = Cache.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

