/*
 * Decompiled with CFR 0.152.
 */
package com.feed.sdk.push;

import android.content.Context;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import com.feed.sdk.push.FeedRegisterManager;
import com.feed.sdk.push.R;
import com.feed.sdk.push.common.Logs;
import com.feed.sdk.push.common.Pref;
import com.feed.sdk.push.exception.GoogleServiceJsonException;
import com.feed.sdk.push.model.ModelDeviceApp;
import com.feed.sdk.push.model.ModelFirebaseApp;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;

public class FeedSDK {
    private static final String TAG = "FeedSDK";
    protected static Class activityClass;
    @DrawableRes
    protected static int notificationIcon;
    private static Context mContext;

    public void setStartActivity(Class activityClass) {
        FeedSDK.activityClass = activityClass;
    }

    public static void setNotificationIcon(@DrawableRes int icon) {
        notificationIcon = icon;
    }

    public static void setEnabled(boolean enable) {
        Pref.get(mContext).put("PREF_ENABLE_KEY", enable);
    }

    public static boolean isEnabled() {
        return Pref.get(mContext).getBoolean("PREF_ENABLE_KEY", true);
    }

    public static void init(Context ctx) {
        mContext = ctx;
        Logs.setEnabled(false);
        FeedSDK.initializeApp(ctx);
        Logs.i("ModelDeviceApp info...", true);
        ModelDeviceApp modelDeviceApp = ModelDeviceApp.getInstance(ctx);
        Logs.i("device_name", modelDeviceApp.device_name);
        Logs.i("device_uuid", modelDeviceApp.device_uuid);
        Logs.i("package_name", modelDeviceApp.package_name);
        Logs.i("app_name", modelDeviceApp.app_name);
        Logs.i("platform", modelDeviceApp.platform);
        FeedRegisterManager.invoke(ctx);
    }

    private static void initializeApp(@NonNull Context context) {
        try {
            ModelFirebaseApp modelFirebaseApp = ModelFirebaseApp.getInstance(context);
            Logs.i("ModelFirebaseApp model initiated successfully...", true);
            Logs.i("api_key", modelFirebaseApp.api_key);
            Logs.i("firebase_url", modelFirebaseApp.firebase_url);
            Logs.i("mobilesdk_app_id", modelFirebaseApp.mobilesdk_app_id);
            Logs.i("project_number", modelFirebaseApp.project_number);
            Logs.i("storage_bucket", modelFirebaseApp.storage_bucket);
            FirebaseApp.initializeApp((Context)context, (FirebaseOptions)new FirebaseOptions.Builder().setApiKey(modelFirebaseApp.api_key).setApplicationId(modelFirebaseApp.mobilesdk_app_id).setDatabaseUrl(modelFirebaseApp.firebase_url).setGcmSenderId(modelFirebaseApp.project_number).setStorageBucket(modelFirebaseApp.storage_bucket).build());
        }
        catch (GoogleServiceJsonException e) {
            e.printStackTrace();
        }
    }

    public static String getToken(Context context) {
        return Pref.get(context).getString("Feed_FCM_TOKEN", null);
    }

    static {
        notificationIcon = R.drawable.ic_notification;
    }
}

