/*
 * Decompiled with CFR 0.152.
 */
package com.feed.sdk.push;

import android.content.Context;
import androidx.annotation.NonNull;
import com.feed.sdk.push.common.Assets;
import com.feed.sdk.push.common.Logs;
import com.feed.sdk.push.common.Pref;
import com.feed.sdk.push.model.ModelDeviceApp;
import com.feed.sdk.push.net.FeedNet;
import com.feed.sdk.push.net.Request;
import com.feed.sdk.push.net.Response;
import com.feed.sdk.push.net.ResponseListener;
import java.util.HashMap;
import org.json.JSONObject;

public class FeedRegisterManager {
    public static final String SETTINGS_FILE_NAME = "push-settings.json";
    public static final String KEY_PROJECT_INFO = "project_info";
    public static final String KEY_USER = "feedify_user";
    public static final String KEY_DKEY = "feedify_dkey";
    public static final String KEY_DOMAIN = "feedify_domain";
    private Context context;

    public FeedRegisterManager(Context context) {
        this.context = context;
    }

    public static void invoke(Context context) {
        String token = Pref.get(context).getString("Feed_FCM_TOKEN", null);
        if (token != null) {
            FeedRegisterManager fm = new FeedRegisterManager(context);
            fm.register(context, ModelDeviceApp.getInstance(context), token);
        }
    }

    public void register(Context context, @NonNull ModelDeviceApp modelDeviceApp, final @NonNull String token) {
        String pushSettingsJson = null;
        String feedify_user = "";
        String feedify_dkey = "";
        String feedify_domain = "";
        try {
            pushSettingsJson = Assets.textFileToString(context, SETTINGS_FILE_NAME);
            JSONObject root = new JSONObject(pushSettingsJson);
            JSONObject project_info = root.getJSONObject(KEY_PROJECT_INFO);
            feedify_user = project_info.getString(KEY_USER);
            feedify_dkey = project_info.getString(KEY_DKEY);
            feedify_domain = project_info.getString(KEY_DOMAIN);
        }
        catch (Exception e) {
            e.printStackTrace();
            Logs.e("Push-settings.json file in missing from assets folder.");
        }
        if (!(feedify_dkey.trim().isEmpty() || feedify_dkey.trim().isEmpty() || feedify_domain.isEmpty())) {
            Logs.i("Registering token...", true);
            String finalFeedify_user = feedify_user;
            String finalFeedify_dkey = feedify_dkey;
            String finalFeedify_domain = feedify_domain;
            HashMap<String, String> MyData = new HashMap<String, String>();
            MyData.put("agent", "Feedify Android Application 1.0");
            MyData.put("endpoint", "https://fcm.googleapis.com/fcm/send/" + token);
            MyData.put("registration_id", token);
            MyData.put("user_id", finalFeedify_user);
            MyData.put("domkey", finalFeedify_dkey);
            MyData.put("referrer", finalFeedify_domain);
            MyData.put("browser", "Android Application");
            MyData.put("uuid", modelDeviceApp.device_uuid);
            Request req = new Request("https://feedify.net/push/register", 1, MyData, new ResponseListener(){

                @Override
                public void onResponse(Response resp) {
                    if (!resp.isError()) {
                        Logs.i("Token sent!!!", token);
                    } else {
                        Logs.e("That didn't work!");
                    }
                }
            });
            FeedNet.getInstance(context).executeRequest(req);
        } else {
            Logs.e("Feedify", "Missing (feedify_user, feedify_dkey, feedify_domain) strings please make sure to update your feedify credentials in push-settings.json.");
        }
    }
}

