/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.uuid.impl;

import com.fasterxml.uuid.NoArgGenerator;
import com.fasterxml.uuid.UUIDType;
import com.fasterxml.uuid.impl.LazyRandom;
import com.fasterxml.uuid.impl.UUIDUtil;
import java.util.Random;
import java.util.UUID;

public class TimeBasedEpochGenerator
extends NoArgGenerator {
    protected final Random _random;

    public TimeBasedEpochGenerator(Random rnd) {
        if (rnd == null) {
            rnd = LazyRandom.sharedSecureRandom();
        }
        this._random = rnd;
    }

    @Override
    public UUIDType getType() {
        return UUIDType.TIME_BASED_EPOCH;
    }

    @Override
    public UUID generate() {
        long rawTimestamp = System.currentTimeMillis();
        byte[] rnd = new byte[10];
        this._random.nextBytes(rnd);
        long l1 = rawTimestamp << 16 | TimeBasedEpochGenerator._toShort(rnd, 8);
        long l2 = TimeBasedEpochGenerator._toLong(rnd, 0);
        return UUIDUtil.constructUUID(UUIDType.TIME_BASED_EPOCH, l1, l2);
    }

    protected static final long _toLong(byte[] buffer, int offset) {
        long l1 = TimeBasedEpochGenerator._toInt(buffer, offset);
        long l2 = TimeBasedEpochGenerator._toInt(buffer, offset + 4);
        long l = (l1 << 32) + (l2 << 32 >>> 32);
        return l;
    }

    private static final long _toInt(byte[] buffer, int offset) {
        return (buffer[offset] << 24) + ((buffer[++offset] & 0xFF) << 16) + ((buffer[++offset] & 0xFF) << 8) + (buffer[++offset] & 0xFF);
    }

    private static final long _toShort(byte[] buffer, int offset) {
        return ((buffer[offset] & 0xFF) << 8) + (buffer[++offset] & 0xFF);
    }
}

