/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.scala.introspect;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.module.scala.introspect.BeanDescriptor;
import com.fasterxml.jackson.module.scala.introspect.ConstructorParameter;
import com.fasterxml.jackson.module.scala.introspect.JavaParameterIntrospector$;
import com.fasterxml.jackson.module.scala.introspect.PropertyDescriptor;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.ArraySeq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.NameTransformer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.matching.Regex;

public final class BeanIntrospector$ {
    public static final BeanIntrospector$ MODULE$ = new BeanIntrospector$();
    private static final Class<Product> productClass = Product.class;

    private Class<Product> productClass() {
        return productClass;
    }

    private Seq<String> getCtorParams(Constructor<?> ctor) {
        IndexedSeq<String> names = JavaParameterIntrospector$.MODULE$.getCtorParamNames(ctor);
        return (Seq)names.map((Function1 & Serializable)name0 -> NameTransformer$.MODULE$.decode(name0));
    }

    public <T> BeanDescriptor apply(Manifest<?> mf) {
        return this.apply(mf.runtimeClass());
    }

    public <T> BeanDescriptor apply(Class<?> cls2) {
        List hierarchy = this.next$1(cls2, (List)package$.MODULE$.Nil());
        Regex privateRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(.*)\\$\\$(.*)"));
        Seq fields = (Seq)hierarchy.flatMap(arg_0 -> BeanIntrospector$.$anonfun$apply$15(this, (Seq)hierarchy, privateRegex, arg_0));
        Seq methods = (Seq)hierarchy.flatMap((Function1 & Serializable)cls -> Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])cls.getDeclaredMethods()), (Function1 & Serializable)getter -> {
            String name = NameTransformer$.MODULE$.decode(getter.getName());
            return new Tuple2(getter, (Object)name);
        }, ClassTag$.MODULE$.apply(Tuple2.class))), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$23(x$8))).withFilter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$24(cls, x$9))).withFilter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$25(x$10))).withFilter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$26(fields, x$11))).map((Function1 & Serializable)x$13 -> {
            Tuple2 tuple2 = x$13;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Method getter = (Method)tuple2._1();
            String name = (String)tuple2._2();
            JsonProperty getterProperty = getter.getAnnotation(JsonProperty.class);
            Option setter = BeanIntrospector$.findSetter$1(cls, name);
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)getterProperty, (Object)setter);
            return tuple3;
        }, ClassTag$.MODULE$.apply(Tuple3.class))), (Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$29(x$14))).map((Function1 & Serializable)x$16 -> {
            Tuple2 tuple2;
            Tuple3 tuple3 = x$16;
            if (tuple3 == null || (tuple2 = (Tuple2)tuple3._1()) == null) {
                throw new MatchError((Object)tuple3);
            }
            String name = (String)tuple2._2();
            Option beanGetter = BeanIntrospector$.findBeanGetter$1(cls, name);
            Option beanSetter = BeanIntrospector$.findBeanSetter$1(cls, name);
            Tuple3 tuple32 = new Tuple3((Object)tuple3, (Object)beanGetter, (Object)beanSetter);
            return tuple32;
        }, ClassTag$.MODULE$.apply(Tuple3.class))), (Function1 & Serializable)x$17 -> {
            Option setter;
            Tuple2 tuple2;
            Option beanSetter;
            Option beanGetter;
            block3: {
                Tuple3 tuple3;
                block2: {
                    tuple3 = x$17;
                    if (tuple3 == null) break block2;
                    Tuple3 tuple32 = (Tuple3)tuple3._1();
                    beanGetter = (Option)tuple3._2();
                    beanSetter = (Option)tuple3._3();
                    if (tuple32 == null) break block2;
                    tuple2 = (Tuple2)tuple32._1();
                    setter = (Option)tuple32._3();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple3);
            }
            Method getter = (Method)tuple2._1();
            String name = (String)tuple2._2();
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(name, (Option<ConstructorParameter>)None$.MODULE$, (Option<Field>)None$.MODULE$, (Option<Method>)new Some((Object)getter), (Option<Method>)setter, (Option<Method>)beanGetter, (Option<Method>)beanSetter);
            return propertyDescriptor;
        }, ClassTag$.MODULE$.apply(PropertyDescriptor.class))));
        return new BeanDescriptor(cls2, (Seq<PropertyDescriptor>)((Seq)fields.$plus$plus((IterableOnce)methods)));
    }

    private final Option findConstructorParam$1(Class c, String name) {
        Option companion;
        int index;
        Option primaryConstructor;
        while (true) {
            block4: {
                block3: {
                    if (c == null) break block3;
                    Class clazz = c;
                    Class<Object> clazz2 = Object.class;
                    if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) break block4;
                }
                return None$.MODULE$;
            }
            primaryConstructor = ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])c.getConstructors()));
            IndexedSeq debugCtorParamNames = (IndexedSeq)Option$.MODULE$.option2Iterable(primaryConstructor).toIndexedSeq().flatMap((Function1 & Serializable)ctor -> MODULE$.getCtorParams((Constructor<?>)ctor));
            index = debugCtorParamNames.indexOf((Object)name);
            companion = BeanIntrospector$.findCompanionObject$1(c);
            if (index >= 0) break;
            c = c.getSuperclass();
        }
        return new Some((Object)new ConstructorParameter((Constructor)primaryConstructor.get(), index, (Option<Function0<Object>>)BeanIntrospector$.findConstructorDefaultValue$1(companion, index)));
    }

    private static final Option findConstructorDefaultValue$1(Option maybeCompanion, int index) {
        String methodName = new StringBuilder(26).append("$lessinit$greater$default$").append(index + 1).toString();
        return maybeCompanion.flatMap((Function1 & Serializable)companion -> Predef$.MODULE$.wrapRefArray((Object[])companion.getClass().getMethods()).toStream().collectFirst((PartialFunction)new Serializable(methodName, companion){
            private static final long serialVersionUID = 0L;
            private final String methodName$1;
            private final Object companion$1;

            public final <A1 extends Method, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                String string = A1.getName();
                String string2 = this.methodName$1;
                Function0 & Serializable intersect = !(string != null ? !string.equals(string2) : string2 != null) && A1.getParameterTypes().length == 0 ? (Function0 & Serializable)() -> A1.invoke($this.companion$1, new Object[0]) : function1.apply(x1);
                return (B1)intersect;
            }

            public final boolean isDefinedAt(Method x1) {
                Method method = x1;
                String string = method.getName();
                String string2 = this.methodName$1;
                boolean bl = !(string != null ? !string.equals(string2) : string2 != null) && method.getParameterTypes().length == 0;
                return bl;
            }
            {
                this.methodName$1 = methodName$1;
                this.companion$1 = companion$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.fasterxml.jackson.module.scala.introspect.BeanIntrospector$$anonfun$$nestedInanonfun$apply$2$1 java.lang.reflect.Method )}, serializedLambda);
            }
        }));
    }

    private static final Option findCompanionObject$1(Class c) {
        Some some;
        try {
            some = new Some(c.getClassLoader().loadClass(new StringBuilder(1).append(c.getName()).append("$").toString()).getDeclaredField("MODULE$").get(null));
        }
        catch (Exception e) {
            some = None$.MODULE$;
        }
        return some;
    }

    private final List next$1(Class c, List acc) {
        while (c != null) {
            Class clazz = c;
            Class<Object> clazz2 = Object.class;
            if (clazz == null) {
                if (clazz2 == null) break;
            } else if (clazz.equals(clazz2)) break;
            acc = (List)acc.$colon$plus((Object)c);
            c = c.getSuperclass();
        }
        return acc;
    }

    private static final Stream listMethods$1(Class cls) {
        Stream stream;
        Class clazz = cls;
        if (clazz == null) {
            stream = package$.MODULE$.Stream().empty();
        } else {
            Class clazz2 = clazz;
            Class<Object> clazz3 = Object.class;
            if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                stream = package$.MODULE$.Stream().empty();
            } else {
                Stream stream2 = Predef$.MODULE$.wrapRefArray((Object[])clazz.getDeclaredMethods()).toStream();
                stream = Stream.Deferrer$.MODULE$.$hash$colon$colon$colon$extension(Stream$.MODULE$.toDeferrer((Function0 & Serializable)() -> BeanIntrospector$.listMethods$1(clazz.getSuperclass())), stream2);
            }
        }
        return stream;
    }

    private static final boolean isNotSyntheticOrBridge$1(Method m) {
        return !m.isBridge() && !m.isSynthetic();
    }

    public static final /* synthetic */ boolean $anonfun$apply$5(String name$1, Method m) {
        String string = NameTransformer$.MODULE$.decode(m.getName());
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final Seq findMethod$1(Class cls, String name) {
        return BeanIntrospector$.listMethods$1(cls).filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.isNotSyntheticOrBridge$1(m))).filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$5(name, m)));
    }

    private static final Stream listFields$1(Class cls) {
        Stream stream;
        Class clazz = cls;
        if (clazz == null) {
            stream = package$.MODULE$.Stream().empty();
        } else {
            Class clazz2 = clazz;
            Class<Object> clazz3 = Object.class;
            if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                stream = package$.MODULE$.Stream().empty();
            } else {
                Stream stream2 = Predef$.MODULE$.wrapRefArray((Object[])clazz.getDeclaredFields()).toStream();
                stream = Stream.Deferrer$.MODULE$.$hash$colon$colon$colon$extension(Stream$.MODULE$.toDeferrer((Function0 & Serializable)() -> BeanIntrospector$.listFields$1(clazz.getSuperclass())), stream2);
            }
        }
        return stream;
    }

    public static final /* synthetic */ boolean $anonfun$apply$7(Field x$1) {
        return !x$1.isSynthetic();
    }

    public static final /* synthetic */ boolean $anonfun$apply$8(String fieldName$1, Field f) {
        String string = NameTransformer$.MODULE$.decode(f.getName());
        String string2 = fieldName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final Option findField$1(Class cls, String fieldName) {
        return Option$.MODULE$.option2Iterable(BeanIntrospector$.listFields$1(cls).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$7(x$1))).find((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$8(fieldName, f)))).headOption();
    }

    private static final boolean isAcceptableField$1(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isVolatile(modifiers) && !Modifier.isTransient(modifiers) && !field.isSynthetic();
    }

    private static final boolean isAcceptableMethod$1(Method method) {
        return !Modifier.isStatic(method.getModifiers()) && BeanIntrospector$.isNotSyntheticOrBridge$1(method);
    }

    private static final Option findGetter$1(Class cls, String propertyName) {
        return BeanIntrospector$.findMethod$1(cls, propertyName).find((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.isAcceptableGetter$1(m)));
    }

    private static final Option findBeanGetter$1(Class cls, String propertyName) {
        return BeanIntrospector$.findMethod$1(cls, new StringBuilder(3).append("get").append(StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(propertyName))).toString()).find((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.isAcceptableGetter$1(m)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isAcceptableGetter$1(Method m) {
        if (!BeanIntrospector$.isAcceptableMethod$1(m)) return false;
        if (m.getParameterTypes().length != 0) return false;
        Class<?> clazz = m.getReturnType();
        Class<Void> clazz2 = Void.TYPE;
        if (clazz == null) {
            if (clazz2 == null) return false;
            return true;
        } else if (clazz.equals(clazz2)) return false;
        return true;
    }

    private static final Option findSetter$1(Class cls, String propertyName) {
        return BeanIntrospector$.findMethod$1(cls, new StringBuilder(2).append(propertyName).append("_=").toString()).find((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.isAcceptableSetter$1(m)));
    }

    private static final Option findBeanSetter$1(Class cls, String propertyName) {
        return BeanIntrospector$.findMethod$1(cls, new StringBuilder(3).append("set").append(StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(propertyName))).toString()).find((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.isAcceptableSetter$1(m)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isAcceptableSetter$1(Method m) {
        if (!BeanIntrospector$.isAcceptableMethod$1(m)) return false;
        if (m.getParameterTypes().length != 1) return false;
        Class<?> clazz = m.getReturnType();
        Class<Void> clazz2 = Void.TYPE;
        if (clazz != null) {
            if (!clazz.equals(clazz2)) return false;
            return true;
        }
        if (clazz2 == null) return true;
        return false;
    }

    private static final String maybePrivateName$1(Field field, Regex privateRegex$1) {
        None$ none$;
        String definedName = NameTransformer$.MODULE$.decode(field.getName());
        try {
            none$ = Option$.MODULE$.apply((Object)field.getDeclaringClass().getCanonicalName());
        }
        catch (InternalError e) {
            none$ = None$.MODULE$;
        }
        None$ canonicalName = none$;
        return (String)canonicalName.flatMap((Function1 & Serializable)cn -> {
            String PrivateName = cn.replace('.', '$');
            String string = definedName;
            if (string == null) return None$.MODULE$;
            Option option = privateRegex$1.unapplySeq((CharSequence)string);
            if (option.isEmpty()) return None$.MODULE$;
            if (option.get() == null) return None$.MODULE$;
            if (((List)option.get()).lengthCompare(2) != 0) return None$.MODULE$;
            String string2 = (String)((LinearSeqOps)option.get()).apply(0);
            String rest = (String)((LinearSeqOps)option.get()).apply(1);
            String string3 = PrivateName;
            String string4 = string2;
            if (string3 != null) {
                if (!string3.equals(string4)) return None$.MODULE$;
                return new Some((Object)rest);
            }
            if (string4 == null) return new Some((Object)rest);
            return None$.MODULE$;
        }).getOrElse((Function0 & Serializable)() -> definedName);
    }

    private final boolean isScalaCaseObject$1(Class cls) {
        return this.productClass().isAssignableFrom(cls) && cls.getName().endsWith("$");
    }

    public static final /* synthetic */ boolean $anonfun$apply$17(Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._2();
        boolean bl = !StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(name), '$');
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$18(BeanIntrospector$ $this, Class cls$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Field field = (Field)tuple2._1();
        boolean bl = $this.isScalaCaseObject$1(cls$1) || BeanIntrospector$.isAcceptableField$1(field);
        return bl;
    }

    public static final /* synthetic */ ArraySeq.ofRef $anonfun$apply$15(BeanIntrospector$ $this, Seq hierarchy$1, Regex privateRegex$1, Class cls) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])cls.getDeclaredFields()), (Function1 & Serializable)field -> {
            String name = BeanIntrospector$.maybePrivateName$1(field, privateRegex$1);
            return new Tuple2(field, (Object)name);
        }, ClassTag$.MODULE$.apply(Tuple2.class))), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$17(x$2))).withFilter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$18($this, cls, x$3))).map((Function1 & Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._2();
            Option beanGetter = BeanIntrospector$.findBeanGetter$1(cls, name);
            Option beanSetter = BeanIntrospector$.findBeanSetter$1(cls, name);
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)beanGetter, (Object)beanSetter);
            return tuple3;
        }, ClassTag$.MODULE$.apply(Tuple3.class))), (Function1 & Serializable)x$6 -> {
            Option beanSetter;
            Option beanGetter;
            Tuple2 tuple2;
            block3: {
                Tuple3 tuple3;
                block2: {
                    tuple3 = x$6;
                    if (tuple3 == null) break block2;
                    tuple2 = (Tuple2)tuple3._1();
                    beanGetter = (Option)tuple3._2();
                    beanSetter = (Option)tuple3._3();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple3);
            }
            Field field = (Field)tuple2._1();
            String name = (String)tuple2._2();
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(name, (Option<ConstructorParameter>)$this.findConstructorParam$1((Class)hierarchy$1.head(), name), (Option<Field>)new Some((Object)field), (Option<Method>)BeanIntrospector$.findGetter$1(cls, name), (Option<Method>)BeanIntrospector$.findSetter$1(cls, name), (Option<Method>)beanGetter, (Option<Method>)beanSetter);
            return propertyDescriptor;
        }, ClassTag$.MODULE$.apply(PropertyDescriptor.class)));
    }

    public static final /* synthetic */ boolean $anonfun$apply$23(Tuple2 x$8) {
        Tuple2 tuple2 = x$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Method getter = (Method)tuple2._1();
        boolean bl = BeanIntrospector$.isAcceptableGetter$1(getter);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$24(Class cls$2, Tuple2 x$9) {
        Tuple2 tuple2 = x$9;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._2();
        boolean bl = BeanIntrospector$.findField$1(cls$2, name).isEmpty();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$25(Tuple2 x$10) {
        Tuple2 tuple2 = x$10;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._2();
        boolean bl = !StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(name), '$');
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$apply$27(String name$2, PropertyDescriptor x$7) {
        String string = x$7.name();
        String string2 = name$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$apply$26(Seq fields$1, Tuple2 x$11) {
        Tuple2 tuple2 = x$11;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._2();
        boolean bl = !fields$1.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)BeanIntrospector$.$anonfun$apply$27(name, x$7)));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$apply$29(Tuple3 x$14) {
        Tuple3 tuple3 = x$14;
        if (tuple3 == null) throw new MatchError((Object)tuple3);
        Tuple2 tuple2 = (Tuple2)tuple3._1();
        JsonProperty getterProperty = (JsonProperty)tuple3._2();
        Option setter = (Option)tuple3._3();
        if (tuple2 == null) throw new MatchError((Object)tuple3);
        if (setter.isDefined()) return true;
        if (getterProperty == null) return false;
        String string = getterProperty.value();
        String string2 = "";
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    private BeanIntrospector$() {
    }
}

