/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.scala.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import scala.Function1;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.reflect.package$;

@ScalaSignature(bytes="\u0006\u0001a3Q!\u0001\u0002\u0002\n=\u0011QCQ5h\u001dVl'-\u001a:EKN,'/[1mSj,'O\u0003\u0002\u0004\t\u0005)A-Z:fe*\u0011QAB\u0001\u0006g\u000e\fG.\u0019\u0006\u0003\u000f!\ta!\\8ek2,'BA\u0005\u000b\u0003\u001dQ\u0017mY6t_:T!a\u0003\u0007\u0002\u0013\u0019\f7\u000f^3sq6d'\"A\u0007\u0002\u0007\r|Wn\u0001\u0001\u0016\u0005Aa2C\u0001\u0001\u0012!\r\u0011\u0002DG\u0007\u0002')\u0011A#F\u0001\u0004gR$'BA\u0002\u0017\u0015\t9\u0002\"\u0001\u0005eCR\f'-\u001b8e\u0013\tI2CA\u000bTi\u0012\u001c6-\u00197be\u0012+7/\u001a:jC2L'0\u001a:\u0011\u0005maB\u0002\u0001\u0003\u0006;\u0001\u0011\rA\b\u0002\u0002)F\u0011q\u0004\n\t\u0003A\tj\u0011!\t\u0006\u0002\u000b%\u00111%\t\u0002\u0005\u001dVdG\u000e\u0005\u0002!K%\u0011a%\t\u0002\u0004\u0003:L\b\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\u000f\r\u0014X-\u0019;peB!\u0001E\u000b\u0017\u001b\u0013\tY\u0013EA\u0005Gk:\u001cG/[8ocA\u0011Q\u0006\u000e\b\u0003]I\u0002\"aL\u0011\u000e\u0003AR!!\r\b\u0002\rq\u0012xn\u001c;?\u0013\t\u0019\u0014%\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u0012aa\u0015;sS:<'BA\u001a\"\u0011!A\u0004AaA!\u0002\u0017I\u0014AC3wS\u0012,gnY3%cA\u0019!(\u0010\u000e\u000e\u0003mR!\u0001P\u0011\u0002\u000fI,g\r\\3di&\u0011ah\u000f\u0002\t\u00072\f7o\u001d+bO\")\u0001\t\u0001C\u0001\u0003\u00061A(\u001b8jiz\"\"A\u0011$\u0015\u0005\r+\u0005c\u0001#\u000155\t!\u0001C\u00039\u007f\u0001\u000f\u0011\bC\u0003)\u007f\u0001\u0007\u0011\u0006C\u0003I\u0001\u0011\u0005\u0013*A\u0006eKN,'/[1mSj,Gc\u0001\u000eK%\")1j\u0012a\u0001\u0019\u0006\u0011!\u000e\u001d\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f\"\tAaY8sK&\u0011\u0011K\u0014\u0002\u000b\u0015N|g\u000eU1sg\u0016\u0014\b\"B*H\u0001\u0004!\u0016\u0001B2uqR\u0004\"!\u0016,\u000e\u0003YI!a\u0016\f\u0003-\u0011+7/\u001a:jC2L'0\u0019;j_:\u001cuN\u001c;fqR\u0004")
public abstract class BigNumberDeserializer<T>
extends StdScalarDeserializer<T> {
    private final Function1<String, T> creator;

    public T deserialize(JsonParser jp, DeserializationContext ctxt) {
        Object object;
        JsonToken t = jp.getCurrentToken();
        JsonToken jsonToken = t;
        boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
        if (bl) {
            object = this.creator.apply((Object)jp.getText().trim());
        } else if (JsonToken.VALUE_STRING.equals(jsonToken)) {
            Object object2;
            String text = jp.getText().trim();
            if (text.isEmpty()) {
                object2 = null;
            } else {
                try {
                    object2 = this.creator.apply((Object)text);
                }
                catch (IllegalArgumentException e) {
                    throw ctxt.weirdStringException(text, this._valueClass, "not a valid representation");
                }
            }
            object = object2;
        } else if (JsonToken.START_ARRAY.equals(jsonToken) && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            jp.nextToken();
            T value = this.deserialize(jp, ctxt);
            JsonToken jsonToken2 = jp.nextToken();
            JsonToken jsonToken3 = JsonToken.END_ARRAY;
            if (jsonToken2 == null ? jsonToken3 != null : !jsonToken2.equals(jsonToken3)) {
                throw ctxt.wrongTokenException(jp, JsonToken.END_ARRAY, "Attempted to unwrap array for single value but there was more than a single value in the array");
            }
            object = value;
        } else {
            object = ctxt.handleUnexpectedToken(this._valueClass, jp);
        }
        return (T)object;
    }

    public BigNumberDeserializer(Function1<String, T> creator, ClassTag<T> evidence$1) {
        this.creator = creator;
        super(package$.MODULE$.classTag(evidence$1).runtimeClass());
    }
}

