/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.kotlin;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.fasterxml.jackson.module.kotlin.MissingKotlinParameterException;
import com.fasterxml.jackson.module.kotlin.ReflectionCache;
import java.io.Closeable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KCallable;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.jvm.KCallablesJvm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J/\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0017\u00a2\u0006\u0002\u0010\u000fJ%\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000bH\u0016\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/fasterxml/jackson/module/kotlin/KotlinValueInstantiator;", "Lcom/fasterxml/jackson/databind/deser/std/StdValueInstantiator;", "src", "cache", "Lcom/fasterxml/jackson/module/kotlin/ReflectionCache;", "(Lcom/fasterxml/jackson/databind/deser/std/StdValueInstantiator;Lcom/fasterxml/jackson/module/kotlin/ReflectionCache;)V", "createFromObjectWith", "", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "props", "", "Lcom/fasterxml/jackson/databind/deser/SettableBeanProperty;", "buffer", "Lcom/fasterxml/jackson/databind/deser/impl/PropertyValueBuffer;", "(Lcom/fasterxml/jackson/databind/DeserializationContext;[Lcom/fasterxml/jackson/databind/deser/SettableBeanProperty;Lcom/fasterxml/jackson/databind/deser/impl/PropertyValueBuffer;)Ljava/lang/Object;", "args", "(Lcom/fasterxml/jackson/databind/DeserializationContext;[Ljava/lang/Object;)Ljava/lang/Object;", "jackson-module-kotlin"})
public final class KotlinValueInstantiator
extends StdValueInstantiator {
    private final ReflectionCache cache;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object createFromObjectWith(@NotNull DeserializationContext ctxt, @NotNull SettableBeanProperty[] props, @NotNull PropertyValueBuffer buffer) {
        Object object;
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
        Intrinsics.checkParameterIsNotNull((Object)props, (String)"props");
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        AnnotatedWithParams annotatedWithParams = this._withArgsCreator;
        if (annotatedWithParams instanceof AnnotatedConstructor) {
            AnnotatedElement annotatedElement = this._withArgsCreator.getAnnotated();
            if (annotatedElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.Constructor<kotlin.Any>");
            }
            object2 = this.cache.kotlinFromJava((Constructor)annotatedElement);
        } else if (annotatedWithParams instanceof AnnotatedMethod) {
            AnnotatedElement annotatedElement = this._withArgsCreator.getAnnotated();
            if (annotatedElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.reflect.Method");
            }
            object2 = this.cache.kotlinFromJava((Method)annotatedElement);
        } else {
            throw (Throwable)new IllegalStateException("Expected a constructor or method to create a Kotlin object, instead found " + this._withArgsCreator.getAnnotated().getClass().getName());
        }
        if (object2 == null) {
            return super.createFromObjectWith(ctxt, props, buffer);
        }
        KFunction<Object> callable = object2;
        HashMap<void, Object> callableParametersByName = new HashMap<void, Object>();
        Object[] jsonParamValueList = new Object[((Object[])props).length];
        Iterable $receiver$iv = callable.getParameters();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            Object paramVal;
            boolean isMissing;
            void paramDef;
            int n = index$iv++;
            KParameter kParameter = (KParameter)item$iv;
            int idx = n;
            if (Intrinsics.areEqual((Object)paramDef.getKind(), (Object)KParameter.Kind.INSTANCE) || Intrinsics.areEqual((Object)paramDef.getKind(), (Object)KParameter.Kind.EXTENSION_RECEIVER)) {
                return super.createFromObjectWith(ctxt, props, buffer);
            }
            SettableBeanProperty jsonProp = (SettableBeanProperty)((Object[])props)[idx];
            boolean bl = isMissing = !buffer.hasParameter(jsonProp);
            if (isMissing && paramDef.isOptional()) continue;
            jsonParamValueList[idx] = paramVal = buffer.getParameter(jsonProp);
            if (paramVal == null && !paramDef.getType().isMarkedNullable()) {
                JsonMappingException jsonMappingException = new MissingKotlinParameterException((KParameter)paramDef, (Closeable)ctxt.getParser(), "Instantiation of " + this.getValueTypeDesc() + " value failed for JSON property " + jsonProp.getName() + " due to missing (therefore NULL) value for creator parameter " + paramDef.getName() + " which is a non-nullable type");
                Class clazz = this.getValueClass();
                String string = jsonProp.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonProp.name");
                JsonMappingException jsonMappingException2 = ExtensionsKt.wrapWithPath(jsonMappingException, (Object)clazz, string);
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonMappingException2, (String)"MissingKotlinParameterEx\u2026alueClass, jsonProp.name)");
                throw (Throwable)jsonMappingException2;
            }
            callableParametersByName.put(paramDef, paramVal);
        }
        if (callableParametersByName.size() == jsonParamValueList.length) {
            object = super.createFromObjectWith(ctxt, jsonParamValueList);
        } else {
            boolean accessible = KCallablesJvm.isAccessible((KCallable)((KCallable)callable));
            if (!accessible && ctxt.getConfig().isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS) || accessible && ctxt.getConfig().isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS)) {
                KCallablesJvm.setAccessible((KCallable)((KCallable)callable), (boolean)true);
            }
            object = callable.callBy((Map)callableParametersByName);
        }
        return object;
    }

    @NotNull
    public Object createFromObjectWith(@NotNull DeserializationContext ctxt, @NotNull Object[] args) {
        Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Object object = super.createFromObjectWith(ctxt, args);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"super.createFromObjectWith(ctxt, args)");
        return object;
    }

    public KotlinValueInstantiator(@NotNull StdValueInstantiator src, @NotNull ReflectionCache cache) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        super(src);
        this.cache = cache;
    }
}

