package com.fasterxml.jackson.module.kotlin

import java.lang.reflect.*
import kotlin.reflect.KType
import kotlin.reflect.jvm.jvmErasure

@Suppress("UNCHECKED_CAST") internal fun Type.erasedType(): Class<Any> {
    return when (this) {
        is Class<*> -> this as Class<Any>
        is ParameterizedType -> this.getRawType().erasedType()
        is GenericArrayType -> {
            // getting the array type is a bit trickier
            val elementType = this.getGenericComponentType().erasedType()
            val testArray = java.lang.reflect.Array.newInstance(elementType, 0)
            testArray.javaClass
        }
        is TypeVariable<*> -> {
            // not sure yet
            throw IllegalStateException("Not sure what to do here yet")
        }
        is WildcardType -> {
            this.getUpperBounds()[0].erasedType()
        }
        else -> throw IllegalStateException("Should not get here.")
    }
}

internal fun KType.erasedType(): Class<out Any> = this.jvmErasure.java