/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema.factories;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.JsonSchemaProducer;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;

public class ArrayVisitor
extends JsonArrayFormatVisitor.Base
implements JsonSchemaProducer {
    protected final ArraySchema schema;
    protected SerializerProvider provider;
    private WrapperFactory wrapperFactory = new WrapperFactory();

    public ArrayVisitor(SerializerProvider provider, ArraySchema schema) {
        this.provider = provider;
        this.schema = schema;
    }

    @Override
    public JsonSchema getSchema() {
        return this.schema;
    }

    public SerializerProvider getProvider() {
        return this.provider;
    }

    public void setProvider(SerializerProvider p) {
        this.provider = p;
    }

    public WrapperFactory getWrapperFactory() {
        return this.wrapperFactory;
    }

    public void setWrapperFactory(WrapperFactory wrapperFactory) {
        this.wrapperFactory = wrapperFactory;
    }

    public void itemsFormat(JsonFormatVisitable handler, JavaType contentType) throws JsonMappingException {
        if (contentType.getRawClass() != Object.class) {
            SchemaFactoryWrapper visitor = this.wrapperFactory.getWrapper(this.getProvider());
            handler.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitor, contentType);
            this.schema.setItemsSchema(visitor.finalSchema());
        }
    }

    public void itemsFormat(JsonFormatTypes format) throws JsonMappingException {
        this.schema.setItemsSchema(JsonSchema.minimalForFormat(format));
    }
}

