/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class OptimizedBeanPropertyWriter<T extends OptimizedBeanPropertyWriter<T>>
extends BeanPropertyWriter {
    protected final BeanPropertyAccessor _propertyAccessor;
    protected final int _propertyIndex;
    protected final BeanPropertyWriter fallbackWriter;
    protected boolean broken = false;

    protected OptimizedBeanPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor propertyAccessor, int propertyIndex, JsonSerializer<Object> ser) {
        super(src);
        this.fallbackWriter = this.unwrapFallbackWriter(src);
        this._serializer = ser != null ? ser : src.getSerializer();
        this._propertyAccessor = propertyAccessor;
        this._propertyIndex = propertyIndex;
    }

    private BeanPropertyWriter unwrapFallbackWriter(BeanPropertyWriter srcIn) {
        while (srcIn instanceof OptimizedBeanPropertyWriter) {
            srcIn = ((OptimizedBeanPropertyWriter)srcIn).fallbackWriter;
        }
        return srcIn;
    }

    public abstract T withAccessor(BeanPropertyAccessor var1);

    public abstract BeanPropertyWriter withSerializer(JsonSerializer<Object> var1);

    public abstract void serializeAsField(Object var1, JsonGenerator var2, SerializerProvider var3) throws Exception;

    public abstract void serializeAsElement(Object var1, JsonGenerator var2, SerializerProvider var3) throws Exception;

    protected void _reportProblem(Object bean, Throwable e) {
        this.broken = true;
        String msg = String.format("Disabling Afterburner serialization for type %s, field #%d, due to access error (type %s, message=%s)%n", bean.getClass(), this._propertyIndex, e.getClass().getName(), e.getMessage());
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, msg, e);
    }
}

