/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class LongMethodPropertyWriter
extends OptimizedBeanPropertyWriter<LongMethodPropertyWriter> {
    private final long _suppressableLong;
    private final boolean _suppressableLongSet;

    public LongMethodPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, JsonSerializer<Object> ser) {
        super(src, acc, index, ser);
        if (MARKER_FOR_EMPTY == this._suppressableValue) {
            this._suppressableLong = 0L;
            this._suppressableLongSet = true;
        } else if (this._suppressableValue instanceof Long) {
            this._suppressableLong = (Long)this._suppressableValue;
            this._suppressableLongSet = true;
        } else {
            this._suppressableLong = 0L;
            this._suppressableLongSet = false;
        }
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new LongMethodPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public LongMethodPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new LongMethodPropertyWriter(this, acc, this._propertyIndex, (JsonSerializer<Object>)this._serializer);
    }

    @Override
    public final void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean, jgen, prov);
            return;
        }
        try {
            long value = this._propertyAccessor.longGetter(bean, this._propertyIndex);
            if (!this._suppressableLongSet || this._suppressableLong != value) {
                jgen.writeFieldName((SerializableString)this._name);
                jgen.writeNumber(value);
            }
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, e);
            this.fallbackWriter.serializeAsField(bean, jgen, prov);
        }
        catch (SecurityException e) {
            this._reportProblem(bean, e);
            this.fallbackWriter.serializeAsField(bean, jgen, prov);
        }
    }
}

