/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.asm.ClassWriter;
import com.fasterxml.jackson.module.afterburner.asm.Label;
import com.fasterxml.jackson.module.afterburner.asm.MethodVisitor;
import com.fasterxml.jackson.module.afterburner.asm.Type;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.IntFieldPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.IntMethodPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.LongFieldPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.LongMethodPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.ObjectFieldPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.ObjectMethodPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.StringFieldPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.StringMethodPropertyWriter;
import com.fasterxml.jackson.module.afterburner.util.DynamicPropertyAccessorBase;
import com.fasterxml.jackson.module.afterburner.util.MyClassLoader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class PropertyAccessorCollector
extends DynamicPropertyAccessorBase {
    private static final Type STRING_TYPE = Type.getType(String.class);
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private final ArrayList<IntMethodPropertyWriter> _intGetters = new ArrayList();
    private final ArrayList<LongMethodPropertyWriter> _longGetters = new ArrayList();
    private final ArrayList<StringMethodPropertyWriter> _stringGetters = new ArrayList();
    private final ArrayList<ObjectMethodPropertyWriter> _objectGetters = new ArrayList();
    private final ArrayList<IntFieldPropertyWriter> _intFields = new ArrayList();
    private final ArrayList<LongFieldPropertyWriter> _longFields = new ArrayList();
    private final ArrayList<StringFieldPropertyWriter> _stringFields = new ArrayList();
    private final ArrayList<ObjectFieldPropertyWriter> _objectFields = new ArrayList();
    private final Class<?> beanClass;
    private final String beanClassName;

    public PropertyAccessorCollector(Class<?> beanClass) {
        this.beanClass = beanClass;
        this.beanClassName = Type.getInternalName(beanClass);
    }

    public IntMethodPropertyWriter addIntGetter(BeanPropertyWriter bpw) {
        return this._add(this._intGetters, new IntMethodPropertyWriter(bpw, null, this._intGetters.size(), null));
    }

    public LongMethodPropertyWriter addLongGetter(BeanPropertyWriter bpw) {
        return this._add(this._longGetters, new LongMethodPropertyWriter(bpw, null, this._longGetters.size(), null));
    }

    public StringMethodPropertyWriter addStringGetter(BeanPropertyWriter bpw) {
        return this._add(this._stringGetters, new StringMethodPropertyWriter(bpw, null, this._stringGetters.size(), null));
    }

    public ObjectMethodPropertyWriter addObjectGetter(BeanPropertyWriter bpw) {
        return this._add(this._objectGetters, new ObjectMethodPropertyWriter(bpw, null, this._objectGetters.size(), null));
    }

    public IntFieldPropertyWriter addIntField(BeanPropertyWriter bpw) {
        return this._add(this._intFields, new IntFieldPropertyWriter(bpw, null, this._intFields.size(), null));
    }

    public LongFieldPropertyWriter addLongField(BeanPropertyWriter bpw) {
        return this._add(this._longFields, new LongFieldPropertyWriter(bpw, null, this._longFields.size(), null));
    }

    public StringFieldPropertyWriter addStringField(BeanPropertyWriter bpw) {
        return this._add(this._stringFields, new StringFieldPropertyWriter(bpw, null, this._stringFields.size(), null));
    }

    public ObjectFieldPropertyWriter addObjectField(BeanPropertyWriter bpw) {
        return this._add(this._objectFields, new ObjectFieldPropertyWriter(bpw, null, this._objectFields.size(), null));
    }

    public boolean isEmpty() {
        return this._intGetters.isEmpty() && this._longGetters.isEmpty() && this._stringGetters.isEmpty() && this._objectGetters.isEmpty() && this._intFields.isEmpty() && this._longFields.isEmpty() && this._stringFields.isEmpty() && this._objectFields.isEmpty();
    }

    public BeanPropertyAccessor findAccessor(MyClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = new MyClassLoader(this.beanClass.getClassLoader(), true);
        }
        String srcName = this.beanClass.getName() + "$Access4JacksonSerializer";
        String generatedClass = PropertyAccessorCollector.internalClassName(srcName);
        Class<?> accessorClass = null;
        try {
            accessorClass = classLoader.loadClass(srcName);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (accessorClass == null) {
            accessorClass = this.generateAccessorClass(classLoader, srcName, generatedClass);
        }
        try {
            return (BeanPropertyAccessor)accessorClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to generate accessor class '" + srcName + "': " + e.getMessage(), e);
        }
    }

    public Class<?> generateAccessorClass(MyClassLoader classLoader, String srcName, String generatedClass) {
        ClassWriter cw = new ClassWriter(1);
        String superClass = PropertyAccessorCollector.internalClassName(BeanPropertyAccessor.class.getName());
        cw.visit(49, 33, generatedClass, null, superClass, null);
        cw.visitSource(srcName + ".java", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superClass, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        if (!this._intFields.isEmpty()) {
            this._addFields(cw, this._intFields, "intField", Type.INT_TYPE, 172);
        }
        if (!this._longFields.isEmpty()) {
            this._addFields(cw, this._longFields, "longField", Type.LONG_TYPE, 173);
        }
        if (!this._stringFields.isEmpty()) {
            this._addFields(cw, this._stringFields, "stringField", STRING_TYPE, 176);
        }
        if (!this._objectFields.isEmpty()) {
            this._addFields(cw, this._objectFields, "objectField", OBJECT_TYPE, 176);
        }
        if (!this._intGetters.isEmpty()) {
            this._addGetters(cw, this._intGetters, "intGetter", Type.INT_TYPE, 172);
        }
        if (!this._longGetters.isEmpty()) {
            this._addGetters(cw, this._longGetters, "longGetter", Type.LONG_TYPE, 173);
        }
        if (!this._stringGetters.isEmpty()) {
            this._addGetters(cw, this._stringGetters, "stringGetter", STRING_TYPE, 176);
        }
        if (!this._objectGetters.isEmpty()) {
            this._addGetters(cw, this._objectGetters, "objectGetter", OBJECT_TYPE, 176);
        }
        cw.visitEnd();
        byte[] byteCode = cw.toByteArray();
        return classLoader.loadAndResolve(srcName, byteCode);
    }

    private <T extends OptimizedBeanPropertyWriter<T>> void _addGetters(ClassWriter cw, List<T> props, String methodName, Type returnType, int returnOpcode) {
        MethodVisitor mv = cw.visitMethod(1, methodName, "(Ljava/lang/Object;I)" + returnType, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.beanClassName);
        mv.visitVarInsn(58, 3);
        if (props.size() <= 4) {
            this._addGettersUsingIf(mv, props, returnOpcode, ALL_INT_CONSTS);
        } else {
            this._addGettersUsingSwitch(mv, props, returnOpcode);
        }
        PropertyAccessorCollector.generateException(mv, this.beanClassName, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private <T extends OptimizedBeanPropertyWriter<T>> void _addFields(ClassWriter cw, List<T> props, String methodName, Type returnType, int returnOpcode) {
        MethodVisitor mv = cw.visitMethod(1, methodName, "(Ljava/lang/Object;I)" + returnType, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.beanClassName);
        mv.visitVarInsn(58, 3);
        if (props.size() < 4) {
            this._addFieldsUsingIf(mv, props, returnOpcode, ALL_INT_CONSTS);
        } else {
            this._addFieldsUsingSwitch(mv, props, returnOpcode);
        }
        PropertyAccessorCollector.generateException(mv, this.beanClassName, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private <T extends OptimizedBeanPropertyWriter<T>> void _addGettersUsingIf(MethodVisitor mv, List<T> props, int returnOpcode, int[] constantOpcodes) {
        mv.visitVarInsn(21, 2);
        Label next = new Label();
        mv.visitJumpInsn(154, next);
        mv.visitVarInsn(25, 3);
        int invokeInsn = this.beanClass.isInterface() ? 185 : 182;
        Method method = (Method)((OptimizedBeanPropertyWriter)((Object)props.get(0))).getMember().getMember();
        mv.visitMethodInsn(invokeInsn, this.beanClassName, method.getName(), Type.getMethodDescriptor((Method)method));
        mv.visitInsn(returnOpcode);
        int len = props.size();
        for (int i = 1; i < len; ++i) {
            mv.visitLabel(next);
            next = new Label();
            mv.visitVarInsn(21, 2);
            mv.visitInsn(constantOpcodes[i]);
            mv.visitJumpInsn(160, next);
            mv.visitVarInsn(25, 3);
            method = (Method)((OptimizedBeanPropertyWriter)((Object)props.get(i))).getMember().getMember();
            mv.visitMethodInsn(invokeInsn, this.beanClassName, method.getName(), Type.getMethodDescriptor((Method)method));
            mv.visitInsn(returnOpcode);
        }
        mv.visitLabel(next);
    }

    private <T extends OptimizedBeanPropertyWriter<T>> void _addGettersUsingSwitch(MethodVisitor mv, List<T> props, int returnOpcode) {
        mv.visitVarInsn(21, 2);
        Label[] labels = new Label[props.size()];
        int len = labels.length;
        for (int i = 0; i < len; ++i) {
            labels[i] = new Label();
        }
        Label defaultLabel = new Label();
        mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
        int invokeInsn = this.beanClass.isInterface() ? 185 : 182;
        int len2 = labels.length;
        for (int i = 0; i < len2; ++i) {
            mv.visitLabel(labels[i]);
            mv.visitVarInsn(25, 3);
            Method method = (Method)((OptimizedBeanPropertyWriter)((Object)props.get(i))).getMember().getMember();
            mv.visitMethodInsn(invokeInsn, this.beanClassName, method.getName(), Type.getMethodDescriptor((Method)method));
            mv.visitInsn(returnOpcode);
        }
        mv.visitLabel(defaultLabel);
    }

    private <T extends OptimizedBeanPropertyWriter<T>> void _addFieldsUsingIf(MethodVisitor mv, List<T> props, int returnOpcode, int[] constantOpcodes) {
        mv.visitVarInsn(21, 2);
        Label next = new Label();
        mv.visitJumpInsn(154, next);
        mv.visitVarInsn(25, 3);
        AnnotatedField field = (AnnotatedField)((OptimizedBeanPropertyWriter)((Object)props.get(0))).getMember();
        mv.visitFieldInsn(180, this.beanClassName, field.getName(), Type.getDescriptor((Class)field.getRawType()));
        mv.visitInsn(returnOpcode);
        int len = props.size();
        for (int i = 1; i < len; ++i) {
            mv.visitLabel(next);
            next = new Label();
            mv.visitVarInsn(21, 2);
            mv.visitInsn(constantOpcodes[i]);
            mv.visitJumpInsn(160, next);
            mv.visitVarInsn(25, 3);
            field = (AnnotatedField)((OptimizedBeanPropertyWriter)((Object)props.get(i))).getMember();
            mv.visitFieldInsn(180, this.beanClassName, field.getName(), Type.getDescriptor((Class)field.getRawType()));
            mv.visitInsn(returnOpcode);
        }
        mv.visitLabel(next);
    }

    private <T extends OptimizedBeanPropertyWriter<T>> void _addFieldsUsingSwitch(MethodVisitor mv, List<T> props, int returnOpcode) {
        mv.visitVarInsn(21, 2);
        Label[] labels = new Label[props.size()];
        int len = labels.length;
        for (int i = 0; i < len; ++i) {
            labels[i] = new Label();
        }
        Label defaultLabel = new Label();
        mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
        int len2 = labels.length;
        for (int i = 0; i < len2; ++i) {
            mv.visitLabel(labels[i]);
            mv.visitVarInsn(25, 3);
            AnnotatedField field = (AnnotatedField)((OptimizedBeanPropertyWriter)((Object)props.get(i))).getMember();
            mv.visitFieldInsn(180, this.beanClassName, field.getName(), Type.getDescriptor((Class)field.getRawType()));
            mv.visitInsn(returnOpcode);
        }
        mv.visitLabel(defaultLabel);
    }
}

