/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class StringFieldPropertyWriter
extends OptimizedBeanPropertyWriter<StringFieldPropertyWriter> {
    public StringFieldPropertyWriter(BeanPropertyWriter beanPropertyWriter, BeanPropertyAccessor beanPropertyAccessor, int n, JsonSerializer<Object> jsonSerializer) {
        super(beanPropertyWriter, beanPropertyAccessor, n, jsonSerializer);
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> jsonSerializer) {
        return new StringFieldPropertyWriter(this, this._propertyAccessor, this._propertyIndex, jsonSerializer);
    }

    @Override
    public StringFieldPropertyWriter withAccessor(BeanPropertyAccessor beanPropertyAccessor) {
        if (beanPropertyAccessor == null) {
            throw new IllegalArgumentException();
        }
        return new StringFieldPropertyWriter(this, beanPropertyAccessor, this._propertyIndex, (JsonSerializer<Object>)this._serializer);
    }

    @Override
    public final void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        String string = this._propertyAccessor.stringField(object, this._propertyIndex);
        if (string == null) {
            if (!this._suppressNulls) {
                jsonGenerator.writeFieldName((SerializableString)this._name);
                serializerProvider.defaultSerializeNull(jsonGenerator);
            }
            return;
        }
        if (this._suppressableValue != null && this._suppressableValue.equals(string)) {
            return;
        }
        jsonGenerator.writeFieldName((SerializableString)this._name);
        jsonGenerator.writeString(string);
    }
}

