/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperSonicBeanDeserializer
extends BeanDeserializer {
    private static final long serialVersionUID = -8468272764223072933L;
    protected final SerializedString[] _orderedPropertyNames;
    protected SettableBeanProperty[] _orderedProperties;

    public SuperSonicBeanDeserializer(BeanDeserializer src, List<SettableBeanProperty> props) {
        super((BeanDeserializerBase)src);
        int len = props.size();
        this._orderedPropertyNames = new SerializedString[len];
        for (int i = 0; i < len; ++i) {
            this._orderedPropertyNames[i] = new SerializedString(props.get(i).getName());
        }
    }

    protected SuperSonicBeanDeserializer(SuperSonicBeanDeserializer src, NameTransformer unwrapper) {
        super((BeanDeserializerBase)src, unwrapper);
        this._orderedProperties = src._orderedProperties;
        this._orderedPropertyNames = src._orderedPropertyNames;
    }

    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer unwrapper) {
        return new SuperSonicBeanDeserializer(this, unwrapper);
    }

    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        SettableBeanProperty prop;
        int i;
        super.resolve(ctxt);
        int len = this._orderedPropertyNames.length;
        ArrayList<SettableBeanProperty> props = new ArrayList<SettableBeanProperty>(len);
        for (i = 0; i < len && (prop = this._beanProperties.find(this._orderedPropertyNames[i].toString())) != null; ++i) {
            props.add(prop);
        }
        if (i == 0) {
            throw new IllegalStateException("Afterburner internal error: BeanDeserializer for " + this._beanType + " has no properties that match expected ordering -- can not create optimized deserializer");
        }
        this._orderedProperties = props.toArray(new SettableBeanProperty[props.size()]);
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt, Object bean) throws IOException, JsonProcessingException {
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        if (this._unwrappedPropertyHandler != null) {
            return this.deserializeWithUnwrapped(jp, ctxt, bean);
        }
        if (this._externalTypeIdHandler != null) {
            return this.deserializeWithExternalTypeId(jp, ctxt, bean);
        }
        JsonToken t = jp.getCurrentToken();
        SettableBeanProperty prop = this._orderedProperties[0];
        if (t == JsonToken.START_OBJECT) {
            if (!jp.nextFieldName((SerializableString)this._orderedPropertyNames[0])) {
                return super.deserialize(jp, ctxt, bean);
            }
            t = jp.nextToken();
        } else if (t != JsonToken.FIELD_NAME || !prop.getName().equals(jp.getCurrentName())) {
            return super.deserialize(jp, ctxt, bean);
        }
        jp.nextToken();
        try {
            prop.deserializeAndSet(jp, ctxt, bean);
        }
        catch (Exception e) {
            this.wrapAndThrow(e, bean, prop.getName(), ctxt);
        }
        int len = this._orderedProperties.length;
        for (int i = 1; i < len; ++i) {
            prop = this._orderedProperties[i];
            if (!jp.nextFieldName((SerializableString)this._orderedPropertyNames[i])) {
                if (jp.getCurrentToken() == JsonToken.END_OBJECT) break;
                return super.deserialize(jp, ctxt, bean);
            }
            jp.nextToken();
            try {
                prop.deserializeAndSet(jp, ctxt, bean);
                continue;
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
        }
        if (jp.nextToken() != JsonToken.END_OBJECT) {
            return super.deserialize(jp, ctxt, bean);
        }
        return bean;
    }

    public Object deserializeFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (this._nonStandardCreation) {
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(jp, ctxt);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(jp, ctxt);
            }
            return this.deserializeFromObjectUsingNonDefault(jp, ctxt);
        }
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        JsonToken t = jp.getCurrentToken();
        SettableBeanProperty prop = this._orderedProperties[0];
        if (t == JsonToken.START_OBJECT) {
            if (!jp.nextFieldName((SerializableString)this._orderedPropertyNames[0])) {
                return super.deserialize(jp, ctxt, bean);
            }
            t = jp.nextToken();
        } else if (t != JsonToken.FIELD_NAME || !prop.getName().equals(jp.getCurrentName())) {
            return super.deserialize(jp, ctxt, bean);
        }
        jp.nextToken();
        try {
            prop.deserializeAndSet(jp, ctxt, bean);
        }
        catch (Exception e) {
            this.wrapAndThrow(e, bean, prop.getName(), ctxt);
        }
        int len = this._orderedProperties.length;
        for (int i = 1; i < len; ++i) {
            prop = this._orderedProperties[i];
            if (!jp.nextFieldName((SerializableString)this._orderedPropertyNames[i])) {
                if (jp.getCurrentToken() == JsonToken.END_OBJECT) break;
                return super.deserialize(jp, ctxt, bean);
            }
            jp.nextToken();
            try {
                prop.deserializeAndSet(jp, ctxt, bean);
                continue;
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
        }
        if (jp.nextToken() != JsonToken.END_OBJECT) {
            return super.deserialize(jp, ctxt, bean);
        }
        return bean;
    }
}

