/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.impl.JSONReader;
import com.fasterxml.jackson.jr.ob.impl.MapBuilder;
import com.fasterxml.jackson.jr.ob.impl.ValueReader;
import java.io.IOException;
import java.util.Map;

public class MapReader
extends ValueReader {
    protected final Class<?> _mapType;
    protected final ValueReader _valueReader;

    public MapReader(Class<?> clazz, ValueReader valueReader) {
        this._mapType = clazz == Map.class ? null : clazz;
        this._valueReader = valueReader;
    }

    @Override
    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        if (jsonParser.nextToken() != JsonToken.START_OBJECT) {
            if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                return null;
            }
            return JSONObjectException.from(jsonParser, "Unexpected token " + jsonParser.getCurrentToken() + "; should get START_OBJECT");
        }
        MapBuilder mapBuilder = jSONReader._mapBuilder(this._mapType);
        String string = jsonParser.nextFieldName();
        if (string == null) {
            if (jsonParser.hasToken(JsonToken.END_OBJECT)) {
                return mapBuilder.emptyMap();
            }
            throw this._reportProblem(jsonParser);
        }
        Object object = this._valueReader.readNext(jSONReader, jsonParser);
        String string2 = jsonParser.nextFieldName();
        if (string2 == null) {
            if (jsonParser.hasToken(JsonToken.END_OBJECT)) {
                return mapBuilder.singletonMap(string, object);
            }
            throw this._reportProblem(jsonParser);
        }
        try {
            mapBuilder = mapBuilder.start().put(string, object);
            do {
                mapBuilder = mapBuilder.put(string2, this._valueReader.readNext(jSONReader, jsonParser));
            } while ((string2 = jsonParser.nextFieldName()) != null);
            if (jsonParser.hasToken(JsonToken.END_OBJECT)) {
                return mapBuilder.build();
            }
            throw this._reportProblem(jsonParser);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JSONObjectException.from(jsonParser, illegalArgumentException.getMessage());
        }
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        MapBuilder mapBuilder = jSONReader._mapBuilder(this._mapType);
        String string = jsonParser.nextFieldName();
        if (string == null) {
            if (jsonParser.hasToken(JsonToken.END_OBJECT)) {
                return mapBuilder.emptyMap();
            }
            throw this._reportProblem(jsonParser);
        }
        Object object = this._valueReader.readNext(jSONReader, jsonParser);
        String string2 = jsonParser.nextFieldName();
        if (string2 == null) {
            if (jsonParser.hasToken(JsonToken.END_OBJECT)) {
                return mapBuilder.singletonMap(string, object);
            }
            throw this._reportProblem(jsonParser);
        }
        try {
            mapBuilder = mapBuilder.start().put(string, object);
            do {
                mapBuilder = mapBuilder.put(string2, this._valueReader.readNext(jSONReader, jsonParser));
            } while ((string2 = jsonParser.nextFieldName()) != null);
            if (jsonParser.hasToken(JsonToken.END_OBJECT)) {
                return mapBuilder.build();
            }
            throw this._reportProblem(jsonParser);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JSONObjectException.from(jsonParser, illegalArgumentException.getMessage());
        }
    }

    protected JSONObjectException _reportProblem(JsonParser jsonParser) {
        return JSONObjectException.from(jsonParser, "Unexpected token " + jsonParser.getCurrentToken() + "; should get FIELD_NAME or END_OBJECT");
    }
}

