/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.jr.ob.impl.JSONReader;
import com.fasterxml.jackson.jr.ob.impl.MapBuilder;
import com.fasterxml.jackson.jr.ob.impl.ValueReader;
import java.io.IOException;
import java.util.Map;

public class MapReader
extends ValueReader {
    protected final Class<?> _mapType;
    protected final ValueReader _valueReader;

    public MapReader(Class<?> clazz, ValueReader valueReader) {
        this._mapType = clazz == Map.class ? null : clazz;
        this._valueReader = valueReader;
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        MapBuilder mapBuilder = jSONReader._mapBuilder(this._mapType);
        if (jsonParser.nextValue() == JsonToken.END_OBJECT) {
            return mapBuilder.emptyMap();
        }
        String string = jsonParser.getCurrentName();
        Object object = this._valueReader.read(jSONReader, jsonParser);
        if (jsonParser.nextValue() == JsonToken.END_OBJECT) {
            return mapBuilder.singletonMap(string, object);
        }
        mapBuilder = mapBuilder.start().put(string, object);
        do {
            mapBuilder = mapBuilder.put(jsonParser.getCurrentName(), this._valueReader.read(jSONReader, jsonParser));
        } while (jsonParser.nextValue() != JsonToken.END_OBJECT);
        return mapBuilder.build();
    }
}

