/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import java.io.IOException;
import java.lang.reflect.Method;

public final class BeanProperty {
    protected final SerializedString _name;
    protected final Class<?> _rawType;
    protected int _typeId;
    protected final Method _getMethod;
    protected final Method _setMethod;

    public BeanProperty(String string, Class<?> clazz, int n, Method method, Method method2) {
        this(new SerializedString(string), clazz, n, method, method2);
    }

    protected BeanProperty(SerializedString serializedString, Class<?> clazz, int n, Method method, Method method2) {
        this._name = serializedString;
        this._rawType = clazz;
        this._getMethod = method;
        this._setMethod = method2;
        this._typeId = n;
    }

    public void overridTypeId(int n) {
        this._typeId = n;
    }

    public Class<?> getType() {
        return this._rawType;
    }

    public int getTypeId() {
        return this._typeId;
    }

    public SerializedString getName() {
        return this._name;
    }

    public SerializedString getNameIfHasSetter() {
        return this._setMethod == null ? null : this._name;
    }

    public Object getValueFor(Object object) throws IOException {
        try {
            return this._getMethod.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw new JSONObjectException("Failed to access property '" + this._name + "' (type " + this._rawType.getName() + "; exception " + exception.getClass().getName() + "): " + exception.getMessage(), exception);
        }
    }

    public Object setValueFor(Object object, Object object2) throws IOException {
        try {
            return this._setMethod.invoke(object, object2);
        }
        catch (Exception exception) {
            throw new JSONObjectException("Failed to set property '" + this._name + "' (type " + this._rawType.getName() + "; exception " + exception.getClass().getName() + "): " + exception.getMessage(), exception);
        }
    }
}

