/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.jr.ob.impl.BeanProperty;
import java.lang.reflect.Constructor;
import java.util.Map;

public class BeanDefinition {
    protected final Class<?> _type;
    protected final BeanProperty[] _properties;
    protected final Map<String, BeanProperty> _propsByName;
    protected final Constructor<?> _defaultCtor;
    protected final Constructor<?> _stringCtor;
    protected final Constructor<?> _longCtor;

    public BeanDefinition(Class<?> clazz, BeanProperty[] beanPropertyArray) {
        this._type = clazz;
        this._properties = beanPropertyArray;
        this._propsByName = null;
        this._defaultCtor = null;
        this._stringCtor = null;
        this._longCtor = null;
    }

    public BeanDefinition(Class<?> clazz, Map<String, BeanProperty> map, Constructor<?> constructor, Constructor<?> constructor2, Constructor<?> constructor3) {
        this._type = clazz;
        this._properties = null;
        this._propsByName = map;
        this._defaultCtor = constructor;
        this._stringCtor = constructor2;
        this._longCtor = constructor3;
    }

    public BeanProperty[] properties() {
        return this._properties;
    }

    public BeanProperty findProperty(String string) {
        return this._propsByName.get(string);
    }

    public Object create() throws Exception {
        if (this._defaultCtor == null) {
            throw new IllegalStateException("Class " + this._type.getName() + " does not have default constructor to use");
        }
        return this._defaultCtor.newInstance(new Object[0]);
    }

    public Object create(String string) throws Exception {
        if (this._stringCtor == null) {
            throw new IllegalStateException("Class " + this._type.getName() + " does not have single-String constructor to use");
        }
        return this._stringCtor.newInstance(string);
    }

    public Object create(long l) throws Exception {
        if (this._longCtor == null) {
            throw new IllegalStateException("Class " + this._type.getName() + " does not have single-long constructor to use");
        }
        return this._longCtor.newInstance(l);
    }
}

