/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.Instantiatable;
import com.fasterxml.jackson.jr.ob.JSONComposer;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.JSONReader;
import com.fasterxml.jackson.jr.ob.JSONWriter;
import com.fasterxml.jackson.jr.ob.PackageVersion;
import com.fasterxml.jackson.jr.ob.impl.CollectionBuilder;
import com.fasterxml.jackson.jr.ob.impl.CollectionComposer;
import com.fasterxml.jackson.jr.ob.impl.JSONAsObjectCodec;
import com.fasterxml.jackson.jr.ob.impl.MapBuilder;
import com.fasterxml.jackson.jr.ob.impl.MapComposer;
import com.fasterxml.jackson.jr.ob.impl.TypeDetector;
import java.io.CharArrayReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JSON
implements Versioned {
    private static final int DEFAULT_FEATURES = Feature.defaults();
    public static final JSON std = new JSON();
    protected final JsonFactory _jsonFactory;
    protected final TreeCodec _treeCodec;
    protected final JSONReader _reader;
    protected final JSONWriter _writer;
    protected final int _features;
    protected final PrettyPrinter _prettyPrinter;

    public JSON() {
        this(DEFAULT_FEATURES, new JsonFactory(), null);
    }

    protected JSON(int n, JsonFactory jsonFactory, TreeCodec treeCodec) {
        this(n, jsonFactory, treeCodec, null, null, null);
    }

    protected JSON(int n, JsonFactory jsonFactory, TreeCodec treeCodec, JSONReader jSONReader, JSONWriter jSONWriter, PrettyPrinter prettyPrinter) {
        this._features = n;
        this._jsonFactory = jsonFactory;
        this._treeCodec = treeCodec;
        this._reader = jSONReader == null ? this._defaultReader(n, treeCodec) : jSONReader;
        this._writer = jSONWriter == null ? this._defaultWriter(n, treeCodec) : jSONWriter;
        this._prettyPrinter = prettyPrinter;
    }

    protected JSONReader _defaultReader(int n, TreeCodec treeCodec) {
        return new JSONReader(n, TypeDetector.rootDetector(false, n), treeCodec, CollectionBuilder.defaultImpl(), MapBuilder.defaultImpl());
    }

    protected JSONWriter _defaultWriter(int n, TreeCodec treeCodec) {
        return new JSONWriter(n, TypeDetector.rootDetector(true, n), treeCodec);
    }

    public ObjectCodec asCodec() {
        return new JSONAsObjectCodec(this);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public JSON with(JsonFactory jsonFactory) {
        if (jsonFactory == this._jsonFactory) {
            return this;
        }
        return this._with(this._features, jsonFactory, this._treeCodec, this._reader, this._writer, this._prettyPrinter);
    }

    public JSON with(TreeCodec treeCodec) {
        if (treeCodec == this._treeCodec) {
            return this;
        }
        return this._with(this._features, this._jsonFactory, treeCodec, this._reader, this._writer.with(treeCodec), this._prettyPrinter);
    }

    public JSON with(JSONReader jSONReader) {
        if (jSONReader == this._reader) {
            return this;
        }
        return this._with(this._features, this._jsonFactory, this._treeCodec, jSONReader, this._writer, this._prettyPrinter);
    }

    public JSON with(JSONWriter jSONWriter) {
        if (jSONWriter == this._writer) {
            return this;
        }
        return this._with(this._features, this._jsonFactory, this._treeCodec, this._reader, jSONWriter, this._prettyPrinter);
    }

    public JSON with(PrettyPrinter prettyPrinter) {
        if (this._prettyPrinter == prettyPrinter) {
            return this;
        }
        return this._with(this._features, this._jsonFactory, this._treeCodec, this._reader, this._writer, prettyPrinter);
    }

    public JSON with(MapBuilder mapBuilder) {
        JSONReader jSONReader = this._reader.with(mapBuilder);
        if (jSONReader == this._reader) {
            return this;
        }
        return this._with(this._features, this._jsonFactory, this._treeCodec, jSONReader, this._writer, this._prettyPrinter);
    }

    public JSON with(CollectionBuilder collectionBuilder) {
        JSONReader jSONReader = this._reader.with(collectionBuilder);
        if (jSONReader == this._reader) {
            return this;
        }
        return this._with(this._features, this._jsonFactory, this._treeCodec, jSONReader, this._writer, this._prettyPrinter);
    }

    public JSON with(Feature feature, boolean bl) {
        int n = this._features;
        n = bl ? (n |= feature.mask()) : (n &= ~feature.mask());
        return this._with(n);
    }

    public JSON with(Feature ... featureArray) {
        int n = this._features;
        for (Feature feature : featureArray) {
            n |= feature.mask();
        }
        return this._with(n);
    }

    public JSON without(Feature ... featureArray) {
        int n = this._features;
        for (Feature feature : featureArray) {
            n &= ~feature.mask();
        }
        return this._with(n);
    }

    protected final JSON _with(int n) {
        if (this._features == n) {
            return this;
        }
        return this._with(n, this._jsonFactory, this._treeCodec, this._reader.withFeatures(n), this._writer.withFeatures(n), this._prettyPrinter);
    }

    protected final JSON _with(int n, JsonFactory jsonFactory, TreeCodec treeCodec, JSONReader jSONReader, JSONWriter jSONWriter, PrettyPrinter prettyPrinter) {
        if (this.getClass() != JSON.class) {
            throw new IllegalStateException("Sub-classes MUST override _with(...)");
        }
        return new JSON(n, jsonFactory, treeCodec, jSONReader, jSONWriter, prettyPrinter);
    }

    public TreeCodec getTreeCodec() {
        return this._treeCodec;
    }

    public JsonFactory getStreamingFactory() {
        return this._jsonFactory;
    }

    public final boolean isEnabled(Feature feature) {
        return (feature.mask() & this._features) != 0;
    }

    public String asString(Object object) throws IOException, JSONObjectException {
        SegmentedStringWriter segmentedStringWriter = new SegmentedStringWriter(this._jsonFactory._getBufferRecycler());
        try {
            this._writeAndClose(object, this._jsonFactory.createGenerator((Writer)segmentedStringWriter));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JSONObjectException.fromUnexpectedIOE(iOException);
        }
        return segmentedStringWriter.getAndClear();
    }

    public byte[] asBytes(Object object) throws IOException, JSONObjectException {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(this._jsonFactory._getBufferRecycler());
        try {
            this._writeAndClose(object, this._jsonFactory.createGenerator((OutputStream)byteArrayBuilder, JsonEncoding.UTF8));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JSONObjectException.fromUnexpectedIOE(iOException);
        }
        byte[] byArray = byteArrayBuilder.toByteArray();
        byteArrayBuilder.release();
        return byArray;
    }

    public void write(Object object, JsonGenerator jsonGenerator) throws IOException, JSONObjectException {
        this._writerForOperation(jsonGenerator).writeValue(object);
        if (Feature.FLUSH_AFTER_WRITE_VALUE.isEnabled(this._features)) {
            jsonGenerator.flush();
        }
    }

    public void write(Object object, OutputStream outputStream) throws IOException, JSONObjectException {
        this._writeAndClose(object, this._jsonFactory.createGenerator(outputStream));
    }

    public void write(Object object, Writer writer) throws IOException, JSONObjectException {
        this._writeAndClose(object, this._jsonFactory.createGenerator(writer));
    }

    public void write(Object object, File file) throws IOException, JSONObjectException {
        this._writeAndClose(object, this._jsonFactory.createGenerator(file, JsonEncoding.UTF8));
    }

    public JSONComposer<OutputStream> composeUsing(JsonGenerator jsonGenerator) throws IOException, JSONObjectException {
        return JSONComposer.streamComposer(this._features, jsonGenerator, false);
    }

    public JSONComposer<OutputStream> composeTo(OutputStream outputStream) throws IOException, JSONObjectException {
        return JSONComposer.streamComposer(this._features, this._jsonFactory.createGenerator(outputStream), true);
    }

    public JSONComposer<OutputStream> composeTo(Writer writer) throws IOException, JSONObjectException {
        return JSONComposer.streamComposer(this._features, this._jsonFactory.createGenerator(writer), true);
    }

    public JSONComposer<OutputStream> composeTo(File file) throws IOException, JSONObjectException {
        return JSONComposer.streamComposer(this._features, this._jsonFactory.createGenerator(file, JsonEncoding.UTF8), true);
    }

    public JSONComposer<String> composeString() throws IOException, JSONObjectException {
        SegmentedStringWriter segmentedStringWriter = new SegmentedStringWriter(this._jsonFactory._getBufferRecycler());
        return JSONComposer.stringComposer(this._features, this._jsonFactory.createGenerator((Writer)segmentedStringWriter), segmentedStringWriter);
    }

    public JSONComposer<byte[]> composeBytes() throws IOException, JSONObjectException {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(this._jsonFactory._getBufferRecycler());
        return JSONComposer.bytesComposer(this._features, this._jsonFactory.createGenerator((OutputStream)byteArrayBuilder), byteArrayBuilder);
    }

    public CollectionComposer<?, List<Object>> composeList() {
        ArrayList arrayList = new ArrayList();
        return this.composeCollection(arrayList);
    }

    public <C extends Collection<Object>> CollectionComposer<?, C> composeCollection(C c) {
        return new CollectionComposer(c);
    }

    public MapComposer<?> composeMap() {
        return this.composeMap(new LinkedHashMap<String, Object>());
    }

    public MapComposer<?> composeMap(Map<String, Object> map) {
        return new MapComposer(map);
    }

    public List<Object> listFrom(Object object) throws IOException, JSONObjectException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            List<Object> list = this._readerForOperation(jsonParser).readList();
            jsonParser.clearCurrentToken();
            return list;
        }
        JsonParser jsonParser = this._parser(object);
        try {
            this._initForReading(this._config(jsonParser));
            List<Object> list = this._readerForOperation(jsonParser).readList();
            JsonParser jsonParser2 = jsonParser;
            jsonParser = null;
            this._close((Closeable)jsonParser2, null);
            return list;
        }
        catch (Exception exception) {
            this._close((Closeable)jsonParser, exception);
            return null;
        }
    }

    public <T> List<T> listOfFrom(Class<T> clazz, Object object) throws IOException, JSONObjectException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            List<T> list = this._readerForOperation(jsonParser).readListOf(clazz);
            jsonParser.clearCurrentToken();
            return list;
        }
        JsonParser jsonParser = this._parser(object);
        try {
            this._initForReading(this._config(jsonParser));
            List<T> list = this._readerForOperation(jsonParser).readListOf(clazz);
            JsonParser jsonParser2 = jsonParser;
            jsonParser = null;
            this._close((Closeable)jsonParser2, null);
            return list;
        }
        catch (Exception exception) {
            this._close((Closeable)jsonParser, exception);
            return null;
        }
    }

    public Object[] arrayFrom(Object object) throws IOException, JSONObjectException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            Object[] objectArray = this._readerForOperation(jsonParser).readArray();
            jsonParser.clearCurrentToken();
            return objectArray;
        }
        JsonParser jsonParser = this._parser(object);
        try {
            this._initForReading(this._config(jsonParser));
            Object[] objectArray = this._readerForOperation(jsonParser).readArray();
            JsonParser jsonParser2 = jsonParser;
            jsonParser = null;
            this._close((Closeable)jsonParser2, null);
            return objectArray;
        }
        catch (Exception exception) {
            this._close((Closeable)jsonParser, exception);
            return null;
        }
    }

    public <T> T[] arrayOfFrom(Class<T> clazz, Object object) throws IOException, JSONObjectException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            T[] TArray = this._readerForOperation(jsonParser).readArrayOf(clazz);
            jsonParser.clearCurrentToken();
            return TArray;
        }
        JsonParser jsonParser = this._parser(object);
        try {
            this._initForReading(this._config(jsonParser));
            T[] TArray = this._readerForOperation(jsonParser).readArrayOf(clazz);
            JsonParser jsonParser2 = jsonParser;
            jsonParser = null;
            this._close((Closeable)jsonParser2, null);
            return TArray;
        }
        catch (Exception exception) {
            this._close((Closeable)jsonParser, exception);
            return null;
        }
    }

    public <T> Map<T, Object> mapFrom(Object object) throws IOException, JSONObjectException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            Map<Object, Object> map = this._readerForOperation(jsonParser).readMap();
            jsonParser.clearCurrentToken();
            return map;
        }
        JsonParser jsonParser = this._parser(object);
        try {
            this._initForReading(this._config(jsonParser));
            Map<Object, Object> map = this._readerForOperation(jsonParser).readMap();
            JsonParser jsonParser2 = jsonParser;
            jsonParser = null;
            this._close((Closeable)jsonParser2, null);
            return map;
        }
        catch (Exception exception) {
            this._close((Closeable)jsonParser, exception);
            return null;
        }
    }

    public <T> T beanFrom(Class<T> clazz, Object object) throws IOException, JSONObjectException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            T t = this._readerForOperation(jsonParser).readBean(clazz);
            jsonParser.clearCurrentToken();
            return t;
        }
        JsonParser jsonParser = this._parser(object);
        try {
            this._initForReading(this._config(jsonParser));
            T t = this._readerForOperation(jsonParser).readBean(clazz);
            JsonParser jsonParser2 = jsonParser;
            jsonParser = null;
            this._close((Closeable)jsonParser2, null);
            return t;
        }
        catch (Exception exception) {
            this._close((Closeable)jsonParser, exception);
            return null;
        }
    }

    public Object anyFrom(Object object) throws IOException, JSONObjectException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            Object object2 = this._readerForOperation(jsonParser).readValue();
            jsonParser.clearCurrentToken();
            return object2;
        }
        JsonParser jsonParser = this._parser(object);
        try {
            this._initForReading(this._config(jsonParser));
            Object object3 = this._readerForOperation(jsonParser).readValue();
            JsonParser jsonParser2 = jsonParser;
            jsonParser = null;
            this._close((Closeable)jsonParser2, null);
            return object3;
        }
        catch (Exception exception) {
            this._close((Closeable)jsonParser, exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void _writeAndClose(Object object, JsonGenerator jsonGenerator) throws IOException, JSONObjectException {
        boolean bl = false;
        try {
            this._config(jsonGenerator);
            this._writerForOperation(jsonGenerator).writeValue(object);
            bl = true;
            jsonGenerator.close();
        }
        finally {
            if (!bl) {
                try {
                    jsonGenerator.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected JSONWriter _writerForOperation(JsonGenerator jsonGenerator) {
        return this._writer.perOperationInstance(jsonGenerator);
    }

    protected JSONReader _readerForOperation(JsonParser jsonParser) {
        return this._reader.perOperationInstance(jsonParser);
    }

    protected JsonParser _parser(Object object) throws IOException, JSONObjectException {
        JsonFactory jsonFactory = this._jsonFactory;
        Class<?> clazz = object.getClass();
        if (clazz == String.class) {
            return jsonFactory.createParser((String)object);
        }
        if (object instanceof InputStream) {
            return jsonFactory.createParser((InputStream)object);
        }
        if (object instanceof Reader) {
            return jsonFactory.createParser((Reader)object);
        }
        if (clazz == byte[].class) {
            return jsonFactory.createParser((byte[])object);
        }
        if (object instanceof URL) {
            return jsonFactory.createParser((URL)object);
        }
        if (clazz == char[].class) {
            return jsonFactory.createParser((Reader)new CharArrayReader((char[])object));
        }
        if (object instanceof CharSequence) {
            return jsonFactory.createParser(((CharSequence)object).toString());
        }
        if (object instanceof JsonParser) {
            throw new IllegalStateException();
        }
        throw new JSONObjectException("Can not use Source of type " + object.getClass().getName() + " as input (use an InputStream, Reader, String, byte[], File or URL");
    }

    protected JsonParser _initForReading(JsonParser jsonParser) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            throw JSONObjectException.from(jsonParser, "No content to map due to end-of-input");
        }
        return jsonParser;
    }

    protected JsonGenerator _config(JsonGenerator jsonGenerator) {
        PrettyPrinter prettyPrinter = this._prettyPrinter;
        if (prettyPrinter != null) {
            if (prettyPrinter instanceof Instantiatable) {
                prettyPrinter = (PrettyPrinter)((Instantiatable)prettyPrinter).createInstance();
            }
            jsonGenerator.setPrettyPrinter(prettyPrinter);
        } else if (this.isEnabled(Feature.PRETTY_PRINT_OUTPUT)) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        return jsonGenerator;
    }

    protected JsonParser _config(JsonParser jsonParser) {
        return jsonParser;
    }

    protected void _close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void _close(Closeable closeable, Exception exception) throws IOException {
        if (closeable != null) {
            if (exception == null) {
                closeable.close();
            } else {
                try {
                    closeable.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        if (exception != null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new IOException(exception);
        }
    }

    public static enum Feature {
        USE_BIG_DECIMAL_FOR_FLOATS(false),
        READ_JSON_ARRAYS_AS_JAVA_ARRAYS(false),
        READ_ONLY(false),
        PRESERVE_FIELD_ORDERING(true),
        FAIL_ON_DUPLICATE_MAP_KEYS(true),
        FAIL_ON_UNKNOWN_BEAN_PROPERTY(false),
        WRITE_NULL_PROPERTIES(false),
        WRITE_READONLY_BEAN_PROPERTIES(true),
        PRETTY_PRINT_OUTPUT(false),
        FLUSH_AFTER_WRITE_VALUE(true),
        FAIL_ON_UNKNOWN_TYPE_WRITE(false),
        HANDLE_JAVA_BEANS(true),
        FORCE_REFLECTION_ACCESS(true);

        private final boolean _defaultState;
        private final int _mask;

        private Feature(boolean bl) {
            this._defaultState = bl;
            this._mask = 1 << this.ordinal();
        }

        public static int defaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.mask();
            }
            return n;
        }

        public final boolean enabledByDefault() {
            return this._defaultState;
        }

        public final int mask() {
            return this._mask;
        }

        public final boolean isDisabled(int n) {
            return (n & this._mask) == 0;
        }

        public final boolean isEnabled(int n) {
            return (n & this._mask) != 0;
        }
    }
}

