/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.xml.util;

import com.fasterxml.jackson.xml.XmlAnnotationIntrospector;
import javax.xml.namespace.QName;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.MapperConfig;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.type.ClassKey;
import org.codehaus.jackson.map.util.LRUMap;
import org.codehaus.jackson.type.JavaType;

public class XmlRootNameLookup {
    protected final LRUMap<ClassKey, QName> _rootNames = new LRUMap(40, 200);

    public QName findRootName(JavaType rootType, MapperConfig<?> config) {
        return this.findRootName(rootType.getRawClass(), config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QName findRootName(Class<?> rootType, MapperConfig<?> config) {
        QName name;
        ClassKey key = new ClassKey(rootType);
        LRUMap<ClassKey, QName> lRUMap = this._rootNames;
        synchronized (lRUMap) {
            name = (QName)this._rootNames.get((Object)key);
            if (name == null) {
                AnnotatedClass ac;
                BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspectClassAnnotations(rootType);
                AnnotationIntrospector intr = config.getAnnotationIntrospector();
                String localName = intr.findRootName(ac = beanDesc.getClassInfo());
                if (localName == null) {
                    localName = rootType.getSimpleName();
                    name = new QName("", localName);
                } else {
                    String ns = this.findNamespace(intr, ac);
                    if (ns == null) {
                        ns = "";
                    }
                    name = new QName(ns, localName);
                }
                this._rootNames.put((Object)key, (Object)name);
            }
        }
        return name;
    }

    private String findNamespace(AnnotationIntrospector ai, AnnotatedClass ann) {
        for (AnnotationIntrospector intr : ai.allIntrospectors()) {
            String ns;
            if (!(intr instanceof XmlAnnotationIntrospector) || (ns = ((XmlAnnotationIntrospector)intr).findNamespace((Annotated)ann)) == null) continue;
            return ns;
        }
        return null;
    }
}

