/*
 * Decompiled with CFR 0.152.
 */
package com.fasten.permission.core;

import android.app.Fragment;
import android.content.Context;
import com.fasten.permission.PermissionActivity;
import com.fasten.permission.PermissionUtils;
import com.fasten.permission.annotation.Permission;
import com.fasten.permission.annotation.PermissionCancel;
import com.fasten.permission.annotation.PermissionDeny;
import com.fasten.permission.core.PermissionListener;
import java.lang.ref.WeakReference;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class PermissionAspectJ {
    @Pointcut(value="execution(@com.fasten.permission.annotation.Permission * *(..)) && @annotation(permission)")
    public void requestPermission(Permission permission) {
    }

    @Around(value="requestPermission(permission)")
    public void aroundJoinPoint(ProceedingJoinPoint joinPoint, Permission permission) {
        Context context = null;
        Object objectActivity = joinPoint.getThis();
        if (joinPoint.getThis() instanceof Context) {
            context = (Context)objectActivity;
        } else if (joinPoint.getThis() instanceof android.support.v4.app.Fragment) {
            context = ((android.support.v4.app.Fragment)objectActivity).getActivity();
        } else if (joinPoint.getThis() instanceof Fragment) {
            context = ((Fragment)objectActivity).getActivity();
        }
        if (context == null || permission == null) {
            return;
        }
        PermissionActivity.requestPermission(context, permission.value(), permission.requestCode(), new ActivityPermissionListener(joinPoint));
    }

    private static class ActivityPermissionListener
    implements PermissionListener {
        private ProceedingJoinPoint ProceedingJoinPoint;
        private WeakReference<Object> mObjectWeakReference;

        public ActivityPermissionListener(ProceedingJoinPoint point) {
            this.ProceedingJoinPoint = point;
            this.mObjectWeakReference = new WeakReference<Object>(point.getThis());
        }

        @Override
        public void grantedPermission() {
            try {
                if (this.ProceedingJoinPoint != null) {
                    this.ProceedingJoinPoint.proceed();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        @Override
        public void cancelPermission() {
            if (this.mObjectWeakReference != null && this.mObjectWeakReference.get() != null) {
                PermissionUtils.invokeAnnotationMethod(this.mObjectWeakReference.get(), PermissionCancel.class);
            }
        }

        @Override
        public void deniedPermission() {
            if (this.mObjectWeakReference != null && this.mObjectWeakReference.get() != null) {
                PermissionUtils.invokeAnnotationMethod(this.mObjectWeakReference.get(), PermissionDeny.class);
            }
        }
    }
}

