/*
 * Decompiled with CFR 0.152.
 */
package com.fasten.permission;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import com.fasten.permission.PermissionUtils;
import com.fasten.permission.R;
import com.fasten.permission.core.PermissionListener;

public class PermissionActivity
extends Activity {
    private static final String PARAM_PERMISSION = "param_permission";
    private static final String PARAM_REQUEST_CODE = "param_request_code";
    private String[] mPermissions;
    private int mRequestCode;
    private static PermissionListener mPermissionListener;

    public static void requestPermission(Context context, String[] permissions, int requestCode, PermissionListener permissionListener) {
        mPermissionListener = permissionListener;
        Intent intent = new Intent(context, PermissionActivity.class);
        intent.setFlags(0x14000000);
        Bundle bundle = new Bundle();
        bundle.putStringArray(PARAM_PERMISSION, permissions);
        bundle.putInt(PARAM_REQUEST_CODE, requestCode);
        intent.putExtras(bundle);
        context.startActivity(intent);
        if (context instanceof Activity) {
            ((Activity)context).overridePendingTransition(0, 0);
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.jp_permission_layout);
        this.mPermissions = this.getIntent().getStringArrayExtra(PARAM_PERMISSION);
        this.mRequestCode = this.getIntent().getIntExtra(PARAM_REQUEST_CODE, -1);
        if (this.mPermissions == null || this.mRequestCode < 0 || mPermissionListener == null) {
            this.finish();
            return;
        }
        if (PermissionUtils.hasPermission((Context)this, this.mPermissions)) {
            mPermissionListener.grantedPermission();
            this.finish();
            return;
        }
        ActivityCompat.requestPermissions((Activity)this, (String[])this.mPermissions, (int)this.mRequestCode);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (mPermissionListener == null) {
            return;
        }
        if (PermissionUtils.verifyPermission((Context)this, grantResults)) {
            mPermissionListener.grantedPermission();
            this.finish();
            return;
        }
        if (!PermissionUtils.shouldShowRequestPermissionRationale(this, permissions)) {
            mPermissionListener.deniedPermission();
            this.finish();
            return;
        }
        mPermissionListener.cancelPermission();
        this.finish();
    }

    protected void onDestroy() {
        super.onDestroy();
        mPermissionListener = null;
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }
}

